/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.factories;

import java.util.HashSet;
import java.util.Set;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.functions.source.datagen.DataGenerator;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.DataGenOptions;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.datagen.DataGenTableSource;
import org.apache.flink.table.factories.datagen.DataGeneratorContainer;
import org.apache.flink.table.factories.datagen.RandomGeneratorVisitor;
import org.apache.flink.table.factories.datagen.SequenceGeneratorVisitor;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalTypeVisitor;
import org.apache.flink.table.utils.TableSchemaUtils;

@PublicEvolving
public class DataGenTableSourceFactory
implements DynamicTableSourceFactory {
    public static final String IDENTIFIER = "datagen";

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return new HashSet();
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(DataGenOptions.ROWS_PER_SECOND);
        options.add(DataGenOptions.NUMBER_OF_ROWS);
        options.add(DataGenOptions.FIELD_KIND);
        options.add(DataGenOptions.FIELD_MIN);
        options.add(DataGenOptions.FIELD_MAX);
        options.add(DataGenOptions.FIELD_LENGTH);
        options.add(DataGenOptions.FIELD_START);
        options.add(DataGenOptions.FIELD_END);
        return options;
    }

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        String name;
        Configuration options = new Configuration();
        context.getCatalogTable().getOptions().forEach((arg_0, arg_1) -> ((Configuration)options).setString(arg_0, arg_1));
        TableSchema schema = TableSchemaUtils.getPhysicalSchema((TableSchema)context.getCatalogTable().getSchema());
        DataGenerator[] fieldGenerators = new DataGenerator[schema.getFieldCount()];
        HashSet<Object> optionalOptions = new HashSet<Object>();
        for (int i = 0; i < fieldGenerators.length; ++i) {
            name = schema.getFieldNames()[i];
            DataType type = schema.getFieldDataTypes()[i];
            ConfigOption kind = ConfigOptions.key((String)("fields." + name + "." + "kind")).stringType().defaultValue((Object)"random");
            DataGeneratorContainer container = this.createContainer(name, type, (String)options.get(kind), (ReadableConfig)options);
            fieldGenerators[i] = container.getGenerator();
            optionalOptions.add(kind);
            optionalOptions.addAll(container.getOptions());
        }
        FactoryUtil.validateFactoryOptions(this.requiredOptions(), optionalOptions, (ReadableConfig)options);
        HashSet<String> consumedOptionKeys = new HashSet<String>();
        consumedOptionKeys.add(FactoryUtil.CONNECTOR.key());
        consumedOptionKeys.add(DataGenOptions.ROWS_PER_SECOND.key());
        consumedOptionKeys.add(DataGenOptions.NUMBER_OF_ROWS.key());
        optionalOptions.stream().map(ConfigOption::key).forEach(consumedOptionKeys::add);
        FactoryUtil.validateUnconsumedKeys((String)this.factoryIdentifier(), (Set)options.keySet(), consumedOptionKeys);
        name = context.getObjectIdentifier().toString();
        return new DataGenTableSource(fieldGenerators, name, schema, (Long)options.get(DataGenOptions.ROWS_PER_SECOND), (Long)options.get(DataGenOptions.NUMBER_OF_ROWS));
    }

    private DataGeneratorContainer createContainer(String name, DataType type, String kind, ReadableConfig options) {
        switch (kind) {
            case "random": {
                return (DataGeneratorContainer)type.getLogicalType().accept((LogicalTypeVisitor)new RandomGeneratorVisitor(name, options));
            }
            case "sequence": {
                return (DataGeneratorContainer)type.getLogicalType().accept((LogicalTypeVisitor)new SequenceGeneratorVisitor(name, options));
            }
        }
        throw new ValidationException("Unsupported generator kind: " + kind);
    }
}

