/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sinks;

import java.util.Arrays;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.DataSink;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.sinks.AppendStreamTableSink;
import org.apache.flink.table.sinks.BatchTableSink;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.table.utils.TableConnectorUtils;
import org.apache.flink.types.Row;

public class CsvTableSink
implements BatchTableSink<Row>,
AppendStreamTableSink<Row> {
    private String path;
    private String fieldDelim;
    private int numFiles = -1;
    private FileSystem.WriteMode writeMode;
    private String[] fieldNames;
    private DataType[] fieldTypes;

    public CsvTableSink(String path, String fieldDelim, int numFiles, FileSystem.WriteMode writeMode, String[] fieldNames, DataType[] fieldTypes) {
        this.path = path;
        this.fieldDelim = fieldDelim;
        this.numFiles = numFiles;
        this.writeMode = writeMode;
        this.fieldNames = fieldNames;
        this.fieldTypes = fieldTypes;
    }

    public CsvTableSink(String path, String fieldDelim, int numFiles, FileSystem.WriteMode writeMode) {
        this.path = path;
        this.fieldDelim = fieldDelim;
        this.numFiles = numFiles;
        this.writeMode = writeMode;
    }

    public CsvTableSink(String path) {
        this(path, ",");
    }

    public CsvTableSink(String path, String fieldDelim) {
        this(path, fieldDelim, -1, null);
    }

    @Override
    public DataSink<?> consumeDataSet(DataSet<Row> dataSet) {
        MapOperator csvRows = dataSet.map((MapFunction)new CsvFormatter(this.fieldDelim == null ? "," : this.fieldDelim));
        DataSink sink = this.writeMode != null ? csvRows.writeAsText(this.path, this.writeMode) : csvRows.writeAsText(this.path);
        if (this.numFiles > 0) {
            csvRows.setParallelism(this.numFiles);
            sink.setParallelism(this.numFiles);
        }
        return sink.name(TableConnectorUtils.generateRuntimeName(CsvTableSink.class, (String[])this.fieldNames));
    }

    @Override
    public DataStreamSink<?> consumeDataStream(DataStream<Row> dataStream) {
        SingleOutputStreamOperator csvRows = dataStream.map((MapFunction)new CsvFormatter(this.fieldDelim == null ? "," : this.fieldDelim));
        DataStreamSink sink = this.writeMode != null ? csvRows.writeAsText(this.path, this.writeMode) : csvRows.writeAsText(this.path);
        if (this.numFiles > 0) {
            csvRows.setParallelism(this.numFiles);
            sink.setParallelism(this.numFiles);
        } else {
            csvRows.setParallelism(dataStream.getParallelism());
            sink.setParallelism(dataStream.getParallelism());
        }
        sink.name(TableConnectorUtils.generateRuntimeName(CsvTableSink.class, (String[])this.fieldNames));
        return sink;
    }

    public TableSink<Row> configure(String[] fieldNames, TypeInformation<?>[] fieldTypes) {
        if (this.fieldNames != null || this.fieldTypes != null) {
            throw new IllegalStateException("CsvTableSink has already been configured field names and field types.");
        }
        DataType[] dataTypes = (DataType[])Arrays.stream(fieldTypes).map(TypeConversions::fromLegacyInfoToDataType).toArray(DataType[]::new);
        return new CsvTableSink(this.path, this.fieldDelim, this.numFiles, this.writeMode, fieldNames, dataTypes);
    }

    public DataType getConsumedDataType() {
        return this.getTableSchema().toRowDataType();
    }

    public TableSchema getTableSchema() {
        return TableSchema.builder().fields(this.fieldNames, this.fieldTypes).build();
    }

    public static class CsvFormatter
    implements MapFunction<Row, String> {
        private static final long serialVersionUID = 1L;
        private final String fieldDelim;

        CsvFormatter(String fieldDelim) {
            this.fieldDelim = fieldDelim;
        }

        public String map(Row row) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < row.getArity(); ++i) {
                Object o;
                if (i > 0) {
                    builder.append(this.fieldDelim);
                }
                if ((o = row.getField(i)) == null) continue;
                builder.append(o);
            }
            return builder.toString();
        }
    }
}

