/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.factories;

import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;

@Internal
public class DataGenOptions {
    public static final Long ROWS_PER_SECOND_DEFAULT_VALUE = 10000L;
    public static final String FIELDS = "fields";
    public static final String KIND = "kind";
    public static final String START = "start";
    public static final String END = "end";
    public static final String MIN = "min";
    public static final String MAX = "max";
    public static final String LENGTH = "length";
    public static final String SEQUENCE = "sequence";
    public static final String RANDOM = "random";
    public static final ConfigOption<Long> ROWS_PER_SECOND = ConfigOptions.key((String)"rows-per-second").longType().defaultValue((Object)ROWS_PER_SECOND_DEFAULT_VALUE).withDescription("Rows per second to control the emit rate.");
    public static final ConfigOption<Long> NUMBER_OF_ROWS = ConfigOptions.key((String)"number-of-rows").longType().noDefaultValue().withDescription("Total number of rows to emit. By default, the source is unbounded.");
    public static final ConfigOption<String> FIELD_KIND = ConfigOptions.key((String)String.format("%s.#.%s", "fields", "kind")).stringType().defaultValue((Object)"random").withDescription("Generator of this '#' field. Can be 'sequence' or 'random'.");
    public static final ConfigOption<String> FIELD_MIN = ConfigOptions.key((String)String.format("%s.#.%s", "fields", "min")).stringType().noDefaultValue().withDescription("Minimum value to generate for fields of kind 'random'. Minimum value possible for the type of the field.");
    public static final ConfigOption<String> FIELD_MAX = ConfigOptions.key((String)String.format("%s.#.%s", "fields", "max")).stringType().noDefaultValue().withDescription("Maximum value to generate for fields of kind 'random'. Maximum value possible for the type of the field.");
    public static final ConfigOption<Integer> FIELD_LENGTH = ConfigOptions.key((String)String.format("%s.#.%s", "fields", "length")).intType().defaultValue((Object)100).withDescription("Size or length of the collection for generating char/varchar/string/array/map/multiset types.");
    public static final ConfigOption<String> FIELD_START = ConfigOptions.key((String)String.format("%s.#.%s", "fields", "start")).stringType().noDefaultValue().withDescription("Start value of sequence generator.");
    public static final ConfigOption<String> FIELD_END = ConfigOptions.key((String)String.format("%s.#.%s", "fields", "end")).stringType().noDefaultValue().withDescription("End value of sequence generator.");

    private DataGenOptions() {
    }
}

