/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.partitioner;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.runtime.plugable.SerializationDelegate;
import org.apache.flink.runtime.state.KeyGroupRangeAssignment;
import org.apache.flink.streaming.runtime.partitioner.ConfigurableStreamPartitioner;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.Preconditions;

@Internal
public class KeyGroupStreamPartitioner<T, K>
extends StreamPartitioner<T>
implements ConfigurableStreamPartitioner {
    private static final long serialVersionUID = 1L;
    private final int[] returnArray = new int[1];
    private final KeySelector<T, K> keySelector;
    private int maxParallelism;

    public KeyGroupStreamPartitioner(KeySelector<T, K> keySelector, int maxParallelism) {
        Preconditions.checkArgument((maxParallelism > 0 ? 1 : 0) != 0, (Object)"Number of key-groups must be > 0!");
        this.keySelector = (KeySelector)Preconditions.checkNotNull(keySelector);
        this.maxParallelism = maxParallelism;
    }

    public int getMaxParallelism() {
        return this.maxParallelism;
    }

    public int[] selectChannels(SerializationDelegate<StreamRecord<T>> record, int numberOfOutputChannels) {
        Object key;
        try {
            key = this.keySelector.getKey(((StreamRecord)record.getInstance()).getValue());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not extract key from " + ((StreamRecord)record.getInstance()).getValue(), e);
        }
        this.returnArray[0] = KeyGroupRangeAssignment.assignKeyToParallelOperator((Object)key, (int)this.maxParallelism, (int)numberOfOutputChannels);
        return this.returnArray;
    }

    @Override
    public StreamPartitioner<T> copy() {
        return this;
    }

    public String toString() {
        return "HASH";
    }

    @Override
    public void configure(int maxParallelism) {
        KeyGroupRangeAssignment.checkParallelismPreconditions((int)maxParallelism);
        this.maxParallelism = maxParallelism;
    }
}

