/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.collect;

import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.coordination.OperatorCoordinator;
import org.apache.flink.runtime.operators.coordination.OperatorEventDispatcher;
import org.apache.flink.streaming.api.operators.CoordinatedOperatorFactory;
import org.apache.flink.streaming.api.operators.SimpleUdfStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.streaming.api.operators.collect.CollectSinkOperator;
import org.apache.flink.streaming.api.operators.collect.CollectSinkOperatorCoordinator;

public class CollectSinkOperatorFactory<IN>
extends SimpleUdfStreamOperatorFactory<Object>
implements CoordinatedOperatorFactory<Object> {
    private static final long serialVersionUID = 1L;
    private static final long DEFAULT_MAX_BYTES_PER_BATCH = 0x200000L;
    private static final int DEFAULT_SOCKET_TIMEOUT_MILLIS = 10000;
    private final CollectSinkOperator<IN> operator = (CollectSinkOperator)this.getOperator();
    private final int socketTimeoutMillis;

    public CollectSinkOperatorFactory(TypeSerializer<IN> serializer, String accumulatorName) {
        this(serializer, accumulatorName, 0x200000L, 10000);
    }

    public CollectSinkOperatorFactory(TypeSerializer<IN> serializer, String accumulatorName, long maxBytesPerBatch, int socketTimeoutMillis) {
        super(new CollectSinkOperator<IN>(serializer, maxBytesPerBatch, accumulatorName));
        this.socketTimeoutMillis = socketTimeoutMillis;
    }

    @Override
    public <T extends StreamOperator<Object>> T createStreamOperator(StreamOperatorParameters<Object> parameters) {
        OperatorID operatorId = parameters.getStreamConfig().getOperatorID();
        OperatorEventDispatcher eventDispatcher = parameters.getOperatorEventDispatcher();
        this.operator.setOperatorEventGateway(eventDispatcher.getOperatorEventGateway(operatorId));
        this.operator.setup(parameters.getContainingTask(), parameters.getStreamConfig(), parameters.getOutput());
        eventDispatcher.registerEventHandler(operatorId, this.operator);
        return (T)this.operator;
    }

    @Override
    public OperatorCoordinator.Provider getCoordinatorProvider(String operatorName, OperatorID operatorID) {
        this.operator.getOperatorIdFuture().complete(operatorID);
        return new CollectSinkOperatorCoordinator.Provider(operatorID, this.socketTimeoutMillis);
    }
}

