/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.streamstatus;

import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.runtime.streamrecord.StreamElement;

@Internal
public final class StreamStatus
extends StreamElement {
    public static final int IDLE_STATUS = -1;
    public static final int ACTIVE_STATUS = 0;
    public static final StreamStatus IDLE = new StreamStatus(-1);
    public static final StreamStatus ACTIVE = new StreamStatus(0);
    public final int status;

    public StreamStatus(int status) {
        if (status != -1 && status != 0) {
            throw new IllegalArgumentException("Invalid status value for StreamStatus; allowed values are 0 (for ACTIVE) and -1 (for IDLE).");
        }
        this.status = status;
    }

    public boolean isIdle() {
        return this.status == -1;
    }

    public boolean isActive() {
        return !this.isIdle();
    }

    public int getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        return this == o || o != null && o.getClass() == StreamStatus.class && ((StreamStatus)o).status == this.status;
    }

    public int hashCode() {
        return this.status;
    }

    public String toString() {
        String statusStr = this.status == 0 ? "ACTIVE" : "IDLE";
        return "StreamStatus(" + statusStr + ")";
    }
}

