/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.io.Serializable;
import org.apache.flink.annotation.PublicEvolving;

@PublicEvolving
public final class InputSelection
implements Serializable {
    public static final int NONE_AVAILABLE = -1;
    private static final long serialVersionUID = 1L;
    public static final InputSelection ALL = new InputSelection(-1L);
    public static final InputSelection FIRST = new Builder().select(1).build();
    public static final InputSelection SECOND = new Builder().select(2).build();
    private final long inputMask;

    private InputSelection(long inputMask) {
        this.inputMask = inputMask;
    }

    public long getInputMask() {
        return this.inputMask;
    }

    public boolean isInputSelected(int inputId) {
        return (this.inputMask & 1L << inputId - 1) != 0L;
    }

    public boolean areAllInputsSelected() {
        return this.inputMask == -1L;
    }

    public int fairSelectNextIndexOutOf2(int availableInputsMask, int lastReadInputIndex) {
        int selectionMask = (int)this.inputMask;
        int combineMask = availableInputsMask & selectionMask;
        if (combineMask == 3) {
            return lastReadInputIndex == 0 ? 1 : 0;
        }
        if (combineMask >= 0 && combineMask < 3) {
            return combineMask - 1;
        }
        throw new UnsupportedOperationException("Only two inputs are supported.");
    }

    public int fairSelectNextIndex(long availableInputsMask, int lastReadInputIndex) {
        long combineMask = availableInputsMask & this.inputMask;
        if (combineMask == 0L) {
            return -1;
        }
        int nextReadInputIndex = this.selectFirstBitRightFromNext(combineMask, lastReadInputIndex + 1);
        if (nextReadInputIndex >= 0) {
            return nextReadInputIndex;
        }
        return this.selectFirstBitRightFromNext(combineMask, 0);
    }

    private int selectFirstBitRightFromNext(long bits, int next) {
        if (next >= 64) {
            return -1;
        }
        bits >>>= next;
        while (bits != 0L && (bits & 1L) != 1L) {
            bits >>>= 1;
            ++next;
        }
        return bits != 0L ? next : -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InputSelection that = (InputSelection)o;
        return this.inputMask == that.inputMask;
    }

    public String toString() {
        return String.valueOf(this.inputMask);
    }

    public static final class Builder {
        private long inputMask = 0L;

        public static Builder from(InputSelection selection) {
            Builder builder = new Builder();
            builder.inputMask = selection.inputMask;
            return builder;
        }

        public Builder select(int inputId) {
            if (inputId > 0 && inputId <= 64) {
                this.inputMask |= 1L << inputId - 1;
            } else if ((long)inputId == -1L) {
                this.inputMask = -1L;
            } else {
                throw new IllegalArgumentException("The inputId must be in the range of 1 to 64, or be -1.");
            }
            return this;
        }

        public InputSelection build(int inputCount) {
            long allSelectedMask = (1L << inputCount) - 1L;
            if (this.inputMask == allSelectedMask) {
                this.inputMask = -1L;
            } else if (this.inputMask > allSelectedMask) {
                throw new IllegalArgumentException(String.format("inputMask [%d] selects more than expected number of inputs [%d]", this.inputMask, inputCount));
            }
            return this.build();
        }

        public InputSelection build() {
            return new InputSelection(this.inputMask);
        }
    }
}

