/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import java.util.concurrent.ScheduledFuture;
import java.util.function.Function;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeCallback;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.streaming.runtime.tasks.TimerService;

class ProcessingTimeServiceImpl
implements ProcessingTimeService {
    private final TimerService timerService;
    private final Function<ProcessingTimeCallback, ProcessingTimeCallback> processingTimeCallbackWrapper;

    ProcessingTimeServiceImpl(TimerService timerService, Function<ProcessingTimeCallback, ProcessingTimeCallback> processingTimeCallbackWrapper) {
        this.timerService = timerService;
        this.processingTimeCallbackWrapper = processingTimeCallbackWrapper;
    }

    @Override
    public long getCurrentProcessingTime() {
        return this.timerService.getCurrentProcessingTime();
    }

    @Override
    public ScheduledFuture<?> registerTimer(long timestamp, ProcessingTimeCallback target) {
        return this.timerService.registerTimer(timestamp, this.processingTimeCallbackWrapper.apply(target));
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(ProcessingTimeCallback callback, long initialDelay, long period) {
        return this.timerService.scheduleAtFixedRate(this.processingTimeCallbackWrapper.apply(callback), initialDelay, period);
    }
}

