/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import javax.annotation.Nullable;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointFailureReason;
import org.apache.flink.runtime.checkpoint.CheckpointMetaData;
import org.apache.flink.runtime.checkpoint.CheckpointMetrics;
import org.apache.flink.runtime.io.network.api.CancelCheckpointMarker;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;

public abstract class CheckpointBarrierHandler {
    @Nullable
    private final AbstractInvokable toNotifyOnCheckpoint;

    public CheckpointBarrierHandler(@Nullable AbstractInvokable toNotifyOnCheckpoint) {
        this.toNotifyOnCheckpoint = toNotifyOnCheckpoint;
    }

    public abstract void releaseBlocksAndResetBarriers();

    public abstract boolean isBlocked(int var1);

    public abstract boolean processBarrier(CheckpointBarrier var1, int var2, long var3) throws Exception;

    public abstract boolean processCancellationBarrier(CancelCheckpointMarker var1) throws Exception;

    public abstract boolean processEndOfPartition() throws Exception;

    public abstract long getLatestCheckpointId();

    public abstract long getAlignmentDurationNanos();

    public abstract void checkpointSizeLimitExceeded(long var1) throws Exception;

    protected void notifyCheckpoint(CheckpointBarrier checkpointBarrier, long bufferedBytes, long alignmentDurationNanos) throws Exception {
        if (this.toNotifyOnCheckpoint != null) {
            CheckpointMetaData checkpointMetaData = new CheckpointMetaData(checkpointBarrier.getId(), checkpointBarrier.getTimestamp());
            CheckpointMetrics checkpointMetrics = new CheckpointMetrics().setBytesBufferedInAlignment(bufferedBytes).setAlignmentDurationNanos(alignmentDurationNanos);
            this.toNotifyOnCheckpoint.triggerCheckpointOnBarrier(checkpointMetaData, checkpointBarrier.getCheckpointOptions(), checkpointMetrics);
        }
    }

    protected void notifyAbortOnCancellationBarrier(long checkpointId) throws Exception {
        this.notifyAbort(checkpointId, new CheckpointException(CheckpointFailureReason.CHECKPOINT_DECLINED_ON_CANCELLATION_BARRIER));
    }

    protected void notifyAbort(long checkpointId, CheckpointException cause) throws Exception {
        if (this.toNotifyOnCheckpoint != null) {
            this.toNotifyOnCheckpoint.abortCheckpointOnBarrier(checkpointId, (Throwable)cause);
        }
    }
}

