/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.transformations;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.shaded.guava18.com.google.common.collect.Lists;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamSink;
import org.apache.flink.streaming.api.transformations.PhysicalTransformation;

@Internal
public class SinkTransformation<T>
extends PhysicalTransformation<Object> {
    private final Transformation<T> input;
    private final StreamOperatorFactory<Object> operatorFactory;
    private KeySelector<T, ?> stateKeySelector;
    private TypeInformation<?> stateKeyType;

    public SinkTransformation(Transformation<T> input, String name, StreamSink<T> operator, int parallelism) {
        this(input, name, SimpleOperatorFactory.of(operator), parallelism);
    }

    public SinkTransformation(Transformation<T> input, String name, StreamOperatorFactory<Object> operatorFactory, int parallelism) {
        super(name, TypeExtractor.getForClass(Object.class), parallelism);
        this.input = input;
        this.operatorFactory = operatorFactory;
    }

    public Transformation<T> getInput() {
        return this.input;
    }

    @VisibleForTesting
    public StreamSink<T> getOperator() {
        return (StreamSink)((SimpleOperatorFactory)this.operatorFactory).getOperator();
    }

    public StreamOperatorFactory<Object> getOperatorFactory() {
        return this.operatorFactory;
    }

    public void setStateKeySelector(KeySelector<T, ?> stateKeySelector) {
        this.stateKeySelector = stateKeySelector;
    }

    public KeySelector<T, ?> getStateKeySelector() {
        return this.stateKeySelector;
    }

    public void setStateKeyType(TypeInformation<?> stateKeyType) {
        this.stateKeyType = stateKeyType;
    }

    public TypeInformation<?> getStateKeyType() {
        return this.stateKeyType;
    }

    public Collection<Transformation<?>> getTransitivePredecessors() {
        ArrayList result = Lists.newArrayList();
        result.add(this);
        result.addAll(this.input.getTransitivePredecessors());
        return result;
    }

    @Override
    public final void setChainingStrategy(ChainingStrategy strategy) {
        this.operatorFactory.setChainingStrategy(strategy);
    }
}

