/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.sink.filesystem;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.util.Preconditions;

@Internal
class BucketState<BucketID> {
    private final BucketID bucketId;
    private final Path bucketPath;
    private final long inProgressFileCreationTime;
    @Nullable
    private final RecoverableWriter.ResumeRecoverable inProgressResumableFile;
    private final Map<Long, List<RecoverableWriter.CommitRecoverable>> committableFilesPerCheckpoint;

    BucketState(BucketID bucketId, Path bucketPath, long inProgressFileCreationTime, @Nullable RecoverableWriter.ResumeRecoverable inProgressResumableFile, Map<Long, List<RecoverableWriter.CommitRecoverable>> pendingCommittablesPerCheckpoint) {
        this.bucketId = Preconditions.checkNotNull(bucketId);
        this.bucketPath = (Path)Preconditions.checkNotNull((Object)bucketPath);
        this.inProgressFileCreationTime = inProgressFileCreationTime;
        this.inProgressResumableFile = inProgressResumableFile;
        this.committableFilesPerCheckpoint = (Map)Preconditions.checkNotNull(pendingCommittablesPerCheckpoint);
    }

    BucketID getBucketId() {
        return this.bucketId;
    }

    Path getBucketPath() {
        return this.bucketPath;
    }

    long getInProgressFileCreationTime() {
        return this.inProgressFileCreationTime;
    }

    boolean hasInProgressResumableFile() {
        return this.inProgressResumableFile != null;
    }

    @Nullable
    RecoverableWriter.ResumeRecoverable getInProgressResumableFile() {
        return this.inProgressResumableFile;
    }

    Map<Long, List<RecoverableWriter.CommitRecoverable>> getCommittableFilesPerCheckpoint() {
        return this.committableFilesPerCheckpoint;
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("BucketState for bucketId=").append(this.bucketId).append(" and bucketPath=").append(this.bucketPath);
        if (this.hasInProgressResumableFile()) {
            strBuilder.append(", has open part file created @ ").append(this.inProgressFileCreationTime);
        }
        if (!this.committableFilesPerCheckpoint.isEmpty()) {
            strBuilder.append(", has pending files for checkpoints: {");
            for (long checkpointId : this.committableFilesPerCheckpoint.keySet()) {
                strBuilder.append(checkpointId).append(' ');
            }
            strBuilder.append('}');
        }
        return strBuilder.toString();
    }
}

