/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import java.util.Collection;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.util.CollectionUtil;

@Internal
@VisibleForTesting
public class OperatorStateHandles {
    private final int operatorChainIndex;
    private final Collection<KeyedStateHandle> managedKeyedState;
    private final Collection<KeyedStateHandle> rawKeyedState;
    private final Collection<OperatorStateHandle> managedOperatorState;
    private final Collection<OperatorStateHandle> rawOperatorState;

    public OperatorStateHandles(int operatorChainIndex, Collection<KeyedStateHandle> managedKeyedState, Collection<KeyedStateHandle> rawKeyedState, Collection<OperatorStateHandle> managedOperatorState, Collection<OperatorStateHandle> rawOperatorState) {
        this.operatorChainIndex = operatorChainIndex;
        this.managedKeyedState = managedKeyedState;
        this.rawKeyedState = rawKeyedState;
        this.managedOperatorState = managedOperatorState;
        this.rawOperatorState = rawOperatorState;
    }

    public Collection<KeyedStateHandle> getManagedKeyedState() {
        return this.managedKeyedState;
    }

    public Collection<KeyedStateHandle> getRawKeyedState() {
        return this.rawKeyedState;
    }

    public Collection<OperatorStateHandle> getManagedOperatorState() {
        return this.managedOperatorState;
    }

    public Collection<OperatorStateHandle> getRawOperatorState() {
        return this.rawOperatorState;
    }

    public int getOperatorChainIndex() {
        return this.operatorChainIndex;
    }

    private static <T> T getSafeItemAtIndexOrNull(List<T> list, int idx) {
        return CollectionUtil.isNullOrEmpty(list) ? null : (T)list.get(idx);
    }
}

