/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks.bufferdebloat;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.io.network.partition.consumer.IndexedInputGate;
import org.apache.flink.streaming.runtime.io.MockInputGate;
import org.apache.flink.streaming.runtime.tasks.bufferdebloat.BufferDebloater;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class BufferDebloaterTest
extends TestLogger {
    @Test
    public void testZeroBuffersInUse() {
        BufferDebloaterTest.testBufferDebloater().withDebloatTarget(1000).withBufferSize(50L, 2400L).withNumberOfBuffersInUse(Arrays.asList(0, 1, 0)).withThroughput(3333L).expectBufferSize(1111);
    }

    @Test
    public void testCorrectBufferSizeCalculation() {
        BufferDebloaterTest.testBufferDebloater().withDebloatTarget(1200).withBufferSize(50L, 1100L).withNumberOfBuffersInUse(Arrays.asList(3, 5, 8)).withThroughput(3333L).expectBufferSize(249);
    }

    @Test
    public void testCalculatedBufferSizeLessThanMin() {
        BufferDebloaterTest.testBufferDebloater().withDebloatTarget(1200).withBufferSize(250L, 1100L).withNumberOfBuffersInUse(Arrays.asList(3, 5, 8)).withThroughput(3333L).expectBufferSize(250);
    }

    @Test
    public void testCalculatedBufferSizeForThroughputZero() {
        BufferDebloaterTest.testBufferDebloater().withDebloatTarget(1200).withBufferSize(50L, 1100L).withNumberOfBuffersInUse(Arrays.asList(3, 5, 8)).withThroughput(0L).expectBufferSize(50);
    }

    @Test
    public void testConfiguredConsumptionTimeIsTooLow() {
        BufferDebloaterTest.testBufferDebloater().withDebloatTarget(7).withBufferSize(50L, 1100L).withNumberOfBuffersInUse(Arrays.asList(3, 5, 8)).withThroughput(3333L).expectBufferSize(50);
    }

    @Test
    public void testCalculatedBufferSizeGreaterThanMax() {
        BufferDebloaterTest.testBufferDebloater().withDebloatTarget(1200).withBufferSize(50L, 248L).withNumberOfBuffersInUse(Arrays.asList(3, 5, 8)).withThroughput(3333L).expectBufferSize(-1);
    }

    @Test
    public void testCalculatedBufferSlightlyDifferentFromCurrentOne() {
        BufferDebloaterTest.testBufferDebloater().withDebloatTarget(1200).withBufferSize(50L, 250L).withNumberOfBuffersInUse(Arrays.asList(3, 5, 8)).withThroughput(3333L).expectBufferSize(-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNegativeMinBufferSize() {
        BufferDebloaterTest.testBufferDebloater().withDebloatTarget(1200).withBufferSize(-1L, 248L).withNumberOfBuffersInUse(Arrays.asList(3, 5, 8)).withThroughput(3333L).expectBufferSize(248);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNegativeMaxBufferSize() {
        BufferDebloaterTest.testBufferDebloater().withDebloatTarget(1200).withBufferSize(50L, -1L).withNumberOfBuffersInUse(Arrays.asList(3, 5, 8)).withThroughput(3333L).expectBufferSize(248);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMinGreaterThanMaxBufferSize() {
        BufferDebloaterTest.testBufferDebloater().withDebloatTarget(1200).withBufferSize(50L, 49L).withNumberOfBuffersInUse(Arrays.asList(3, 5, 8)).withThroughput(3333L).expectBufferSize(248);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNegativeConsumptionTime() {
        BufferDebloaterTest.testBufferDebloater().withDebloatTarget(-1).withBufferSize(50L, 1100L).withNumberOfBuffersInUse(Arrays.asList(3, 5, 8)).withThroughput(3333L).expectBufferSize(248);
    }

    @Test
    public void testAnnouncedMaxBufferSizeDespiteLastDiffLessThanThreshold() {
        BufferDebloater bufferDebloater = BufferDebloaterTest.testBufferDebloater().withDebloatTarget(1000).withBufferSize(50L, 1100L).withNumberOfBuffersInUse(Collections.singletonList(1)).withThroughput(500L).expectBufferSize(500);
        bufferDebloater.recalculateBufferSize(1000L);
        MatcherAssert.assertThat((Object)bufferDebloater.getLastBufferSize(), (Matcher)CoreMatchers.is((Object)1000));
        bufferDebloater.recalculateBufferSize(2000L);
        MatcherAssert.assertThat((Object)bufferDebloater.getLastBufferSize(), (Matcher)CoreMatchers.is((Object)1100));
        bufferDebloater.recalculateBufferSize(2000L);
    }

    @Test
    public void testAnnouncedMinBufferSizeEvenDespiteLastDiffLessThanThreshold() {
        BufferDebloater bufferDebloater = BufferDebloaterTest.testBufferDebloater().withDebloatTarget(1000).withBufferSize(50L, 1100L).withNumberOfBuffersInUse(Collections.singletonList(1)).withThroughput(60L).expectBufferSize(60);
        bufferDebloater.recalculateBufferSize(60L);
        MatcherAssert.assertThat((Object)bufferDebloater.getLastBufferSize(), (Matcher)CoreMatchers.is((Object)60));
        bufferDebloater.recalculateBufferSize(40L);
        MatcherAssert.assertThat((Object)bufferDebloater.getLastBufferSize(), (Matcher)CoreMatchers.is((Object)50));
        bufferDebloater.recalculateBufferSize(40L);
    }

    @Test
    public void testSkipUpdate() {
        int maxBufferSize = 32768;
        int minBufferSize = 256;
        double threshold = 0.3;
        int currentBufferSize = maxBufferSize / 2;
        BufferDebloater bufferDebloater = BufferDebloaterTest.testBufferDebloater().withDebloatTarget(1000).withBufferSize(minBufferSize, maxBufferSize).withThresholdPercentages((int)(threshold * 100.0)).withThroughput(currentBufferSize).withNumberOfBuffersInUse(Collections.singletonList(1)).expectBufferSize(currentBufferSize);
        Assert.assertTrue((boolean)bufferDebloater.skipUpdate(currentBufferSize));
        Assert.assertTrue((boolean)bufferDebloater.skipUpdate(currentBufferSize - 1));
        Assert.assertTrue((boolean)bufferDebloater.skipUpdate(currentBufferSize + 1));
        Assert.assertTrue((boolean)bufferDebloater.skipUpdate(currentBufferSize - (int)((double)currentBufferSize * threshold) + 1));
        Assert.assertTrue((boolean)bufferDebloater.skipUpdate(currentBufferSize + (int)((double)currentBufferSize * threshold) - 1));
        Assert.assertFalse((boolean)bufferDebloater.skipUpdate(currentBufferSize - (int)((double)currentBufferSize * threshold)));
        Assert.assertFalse((boolean)bufferDebloater.skipUpdate(currentBufferSize + (int)((double)currentBufferSize * threshold)));
        Assert.assertFalse((boolean)bufferDebloater.skipUpdate(minBufferSize + 1));
        Assert.assertFalse((boolean)bufferDebloater.skipUpdate(minBufferSize));
        Assert.assertFalse((boolean)bufferDebloater.skipUpdate(maxBufferSize - 1));
        Assert.assertFalse((boolean)bufferDebloater.skipUpdate(maxBufferSize));
        Assert.assertFalse((boolean)bufferDebloater.skipUpdate(maxBufferSize + 1));
        Assert.assertFalse((boolean)bufferDebloater.skipUpdate(minBufferSize - 1));
    }

    public static BufferDebloaterTestBuilder testBufferDebloater() {
        return new BufferDebloaterTestBuilder();
    }

    private static class BufferDebloaterTestBuilder {
        private List<Integer> numberOfBuffersInUse;
        private long throughput;
        private long minBufferSize;
        private long maxBufferSize;
        private int debloatTarget;
        private int thresholdPercentages = (Integer)TaskManagerOptions.BUFFER_DEBLOAT_THRESHOLD_PERCENTAGES.defaultValue();

        private BufferDebloaterTestBuilder() {
        }

        public BufferDebloaterTestBuilder withNumberOfBuffersInUse(List<Integer> numberOfBuffersInUse) {
            this.numberOfBuffersInUse = numberOfBuffersInUse;
            return this;
        }

        public BufferDebloaterTestBuilder withThroughput(long throughput) {
            this.throughput = throughput;
            return this;
        }

        public BufferDebloaterTestBuilder withBufferSize(long minBufferSize, long maxBufferSize) {
            this.minBufferSize = minBufferSize;
            this.maxBufferSize = maxBufferSize;
            return this;
        }

        public BufferDebloaterTestBuilder withDebloatTarget(int debloatTarget) {
            this.debloatTarget = debloatTarget;
            return this;
        }

        public BufferDebloaterTestBuilder withThresholdPercentages(int thresholdPercentages) {
            this.thresholdPercentages = thresholdPercentages;
            return this;
        }

        public BufferDebloater expectBufferSize(int expectedBufferSize) {
            int numberOfGates = this.numberOfBuffersInUse.size();
            IndexedInputGate[] inputGates = new TestBufferSizeInputGate[numberOfGates];
            for (int i = 0; i < numberOfGates; ++i) {
                inputGates[i] = new TestBufferSizeInputGate(this.numberOfBuffersInUse.get(i));
            }
            BufferDebloater bufferDebloater = new BufferDebloater(new Configuration().set(TaskManagerOptions.BUFFER_DEBLOAT_ENABLED, (Object)true).set(TaskManagerOptions.BUFFER_DEBLOAT_TARGET, (Object)Duration.ofMillis(this.debloatTarget)).set(TaskManagerOptions.BUFFER_DEBLOAT_THRESHOLD_PERCENTAGES, (Object)this.thresholdPercentages).set(TaskManagerOptions.MEMORY_SEGMENT_SIZE, (Object)MemorySize.parse((String)("" + this.maxBufferSize), (MemorySize.MemoryUnit)MemorySize.MemoryUnit.BYTES)).set(TaskManagerOptions.MIN_MEMORY_SEGMENT_SIZE, (Object)MemorySize.parse((String)("" + this.minBufferSize), (MemorySize.MemoryUnit)MemorySize.MemoryUnit.BYTES)), inputGates);
            bufferDebloater.recalculateBufferSize(this.throughput);
            for (int i = 0; i < numberOfGates; ++i) {
                MatcherAssert.assertThat((Object)((TestBufferSizeInputGate)inputGates[i]).lastBufferSize, (Matcher)CoreMatchers.is((Object)expectedBufferSize));
            }
            return bufferDebloater;
        }
    }

    private static class TestBufferSizeInputGate
    extends MockInputGate {
        private int lastBufferSize = -1;
        private final int bufferInUseCount;

        public TestBufferSizeInputGate(int bufferInUseCount) {
            super(1, Collections.emptyList(), false);
            this.bufferInUseCount = bufferInUseCount;
        }

        @Override
        public int getBuffersInUseCount() {
            return this.bufferInUseCount;
        }

        @Override
        public void announceBufferSize(int bufferSize) {
            MatcherAssert.assertThat((Object)bufferSize, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)this.lastBufferSize)));
            this.lastBufferSize = bufferSize;
        }
    }
}

