/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import java.util.function.Supplier;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointMetaData;
import org.apache.flink.runtime.checkpoint.CheckpointMetricsBuilder;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriter;
import org.apache.flink.runtime.state.CheckpointStorageWorkerView;
import org.apache.flink.runtime.state.TestCheckpointStorageWorkerView;
import org.apache.flink.streaming.runtime.tasks.OperatorChain;
import org.apache.flink.streaming.runtime.tasks.SubtaskCheckpointCoordinator;

public class TestSubtaskCheckpointCoordinator
implements SubtaskCheckpointCoordinator {
    public static final TestSubtaskCheckpointCoordinator INSTANCE = new TestSubtaskCheckpointCoordinator();
    private static final int DEFAULT_MAX_STATE_SIZE = 1000;
    private final CheckpointStorageWorkerView storageWorkerView;
    private final ChannelStateWriter channelStateWriter;

    private TestSubtaskCheckpointCoordinator() {
        this((CheckpointStorageWorkerView)new TestCheckpointStorageWorkerView(1000), ChannelStateWriter.NO_OP);
    }

    public TestSubtaskCheckpointCoordinator(ChannelStateWriter channelStateWriter) {
        this((CheckpointStorageWorkerView)new TestCheckpointStorageWorkerView(1000), channelStateWriter);
    }

    private TestSubtaskCheckpointCoordinator(CheckpointStorageWorkerView storageWorkerView, ChannelStateWriter channelStateWriter) {
        this.storageWorkerView = storageWorkerView;
        this.channelStateWriter = channelStateWriter;
    }

    public void initInputsCheckpoint(long id, CheckpointOptions checkpointOptions) {
        this.channelStateWriter.start(id, checkpointOptions);
    }

    public ChannelStateWriter getChannelStateWriter() {
        return this.channelStateWriter;
    }

    public CheckpointStorageWorkerView getCheckpointStorage() {
        return this.storageWorkerView;
    }

    public void abortCheckpointOnBarrier(long checkpointId, CheckpointException cause, OperatorChain<?, ?> operatorChain) {
        this.channelStateWriter.abort(checkpointId, (Throwable)cause, true);
    }

    public void checkpointState(CheckpointMetaData checkpointMetaData, CheckpointOptions checkpointOptions, CheckpointMetricsBuilder checkpointMetrics, OperatorChain<?, ?> operatorChain, boolean isTaskFinished, Supplier<Boolean> isRunning) {
    }

    public void notifyCheckpointComplete(long checkpointId, OperatorChain<?, ?> operatorChain, Supplier<Boolean> isRunning) {
    }

    public void notifyCheckpointAborted(long checkpointId, OperatorChain<?, ?> operatorChain, Supplier<Boolean> isRunning) {
    }

    public void waitForPendingCheckpoints() throws Exception {
    }

    public void close() {
    }
}

