/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import java.util.Collection;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.shaded.guava30.com.google.common.collect.Lists;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.windowing.assigners.DynamicProcessingTimeSessionWindows;
import org.apache.flink.streaming.api.windowing.assigners.MergingWindowAssigner;
import org.apache.flink.streaming.api.windowing.assigners.SessionWindowTimeGapExtractor;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.triggers.ProcessingTimeTrigger;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.apache.flink.streaming.util.StreamRecordMatchers;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.hamcrest.MockitoHamcrest;
import org.mockito.verification.VerificationMode;

public class DynamicProcessingTimeSessionWindowsTest
extends TestLogger {
    @Test
    public void testWindowAssignment() {
        WindowAssigner.WindowAssignerContext mockContext = (WindowAssigner.WindowAssignerContext)Mockito.mock(WindowAssigner.WindowAssignerContext.class);
        SessionWindowTimeGapExtractor extractor = (SessionWindowTimeGapExtractor)Mockito.mock(SessionWindowTimeGapExtractor.class);
        Mockito.when((Object)extractor.extract(Mockito.eq((Object)"gap5000"))).thenReturn((Object)5000L);
        Mockito.when((Object)extractor.extract(Mockito.eq((Object)"gap4000"))).thenReturn((Object)4000L);
        Mockito.when((Object)extractor.extract(Mockito.eq((Object)"gap9000"))).thenReturn((Object)9000L);
        DynamicProcessingTimeSessionWindows assigner = DynamicProcessingTimeSessionWindows.withDynamicGap((SessionWindowTimeGapExtractor)extractor);
        Mockito.when((Object)mockContext.getCurrentProcessingTime()).thenReturn((Object)0L);
        Assert.assertThat((Object)assigner.assignWindows((Object)"gap5000", Long.MIN_VALUE, mockContext), (Matcher)Matchers.contains(StreamRecordMatchers.timeWindow(0L, 5000L)));
        Mockito.when((Object)mockContext.getCurrentProcessingTime()).thenReturn((Object)4999L);
        Assert.assertThat((Object)assigner.assignWindows((Object)"gap4000", Long.MIN_VALUE, mockContext), (Matcher)Matchers.contains(StreamRecordMatchers.timeWindow(4999L, 8999L)));
        Mockito.when((Object)mockContext.getCurrentProcessingTime()).thenReturn((Object)5000L);
        Assert.assertThat((Object)assigner.assignWindows((Object)"gap9000", Long.MIN_VALUE, mockContext), (Matcher)Matchers.contains(StreamRecordMatchers.timeWindow(5000L, 14000L)));
    }

    @Test
    public void testMergeSinglePointWindow() {
        MergingWindowAssigner.MergeCallback callback = (MergingWindowAssigner.MergeCallback)Mockito.mock(MergingWindowAssigner.MergeCallback.class);
        SessionWindowTimeGapExtractor extractor = (SessionWindowTimeGapExtractor)Mockito.mock(SessionWindowTimeGapExtractor.class);
        Mockito.when((Object)extractor.extract(org.mockito.Matchers.any())).thenReturn((Object)5000L);
        DynamicProcessingTimeSessionWindows assigner = DynamicProcessingTimeSessionWindows.withDynamicGap((SessionWindowTimeGapExtractor)extractor);
        assigner.mergeWindows((Collection)Lists.newArrayList((Object[])new TimeWindow[]{new TimeWindow(0L, 0L)}), callback);
        ((MergingWindowAssigner.MergeCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.never())).merge(org.mockito.Matchers.anyCollection(), org.mockito.Matchers.anyObject());
    }

    @Test
    public void testMergeSingleWindow() {
        MergingWindowAssigner.MergeCallback callback = (MergingWindowAssigner.MergeCallback)Mockito.mock(MergingWindowAssigner.MergeCallback.class);
        SessionWindowTimeGapExtractor extractor = (SessionWindowTimeGapExtractor)Mockito.mock(SessionWindowTimeGapExtractor.class);
        Mockito.when((Object)extractor.extract(org.mockito.Matchers.any())).thenReturn((Object)5000L);
        DynamicProcessingTimeSessionWindows assigner = DynamicProcessingTimeSessionWindows.withDynamicGap((SessionWindowTimeGapExtractor)extractor);
        assigner.mergeWindows((Collection)Lists.newArrayList((Object[])new TimeWindow[]{new TimeWindow(0L, 1L)}), callback);
        ((MergingWindowAssigner.MergeCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.never())).merge(org.mockito.Matchers.anyCollection(), org.mockito.Matchers.anyObject());
    }

    @Test
    public void testMergeConsecutiveWindows() {
        MergingWindowAssigner.MergeCallback callback = (MergingWindowAssigner.MergeCallback)Mockito.mock(MergingWindowAssigner.MergeCallback.class);
        SessionWindowTimeGapExtractor extractor = (SessionWindowTimeGapExtractor)Mockito.mock(SessionWindowTimeGapExtractor.class);
        Mockito.when((Object)extractor.extract(org.mockito.Matchers.any())).thenReturn((Object)5000L);
        DynamicProcessingTimeSessionWindows assigner = DynamicProcessingTimeSessionWindows.withDynamicGap((SessionWindowTimeGapExtractor)extractor);
        assigner.mergeWindows((Collection)Lists.newArrayList((Object[])new TimeWindow[]{new TimeWindow(0L, 1L), new TimeWindow(1L, 2L), new TimeWindow(2L, 3L), new TimeWindow(4L, 5L), new TimeWindow(5L, 6L)}), callback);
        ((MergingWindowAssigner.MergeCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).merge((Collection)MockitoHamcrest.argThat((Matcher)Matchers.containsInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(0L, 1L), new TimeWindow(1L, 2L), new TimeWindow(2L, 3L)})), Mockito.eq((Object)new TimeWindow(0L, 3L)));
        ((MergingWindowAssigner.MergeCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).merge((Collection)MockitoHamcrest.argThat((Matcher)Matchers.containsInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(4L, 5L), new TimeWindow(5L, 6L)})), Mockito.eq((Object)new TimeWindow(4L, 6L)));
        ((MergingWindowAssigner.MergeCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)2))).merge(org.mockito.Matchers.anyCollection(), org.mockito.Matchers.anyObject());
    }

    @Test
    public void testMergeCoveringWindow() {
        MergingWindowAssigner.MergeCallback callback = (MergingWindowAssigner.MergeCallback)Mockito.mock(MergingWindowAssigner.MergeCallback.class);
        SessionWindowTimeGapExtractor extractor = (SessionWindowTimeGapExtractor)Mockito.mock(SessionWindowTimeGapExtractor.class);
        Mockito.when((Object)extractor.extract(org.mockito.Matchers.any())).thenReturn((Object)5000L);
        DynamicProcessingTimeSessionWindows assigner = DynamicProcessingTimeSessionWindows.withDynamicGap((SessionWindowTimeGapExtractor)extractor);
        assigner.mergeWindows((Collection)Lists.newArrayList((Object[])new TimeWindow[]{new TimeWindow(1L, 1L), new TimeWindow(0L, 2L), new TimeWindow(4L, 7L), new TimeWindow(5L, 6L)}), callback);
        ((MergingWindowAssigner.MergeCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).merge((Collection)MockitoHamcrest.argThat((Matcher)Matchers.containsInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(1L, 1L), new TimeWindow(0L, 2L)})), Mockito.eq((Object)new TimeWindow(0L, 2L)));
        ((MergingWindowAssigner.MergeCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).merge((Collection)MockitoHamcrest.argThat((Matcher)Matchers.containsInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(5L, 6L), new TimeWindow(4L, 7L)})), Mockito.eq((Object)new TimeWindow(4L, 7L)));
        ((MergingWindowAssigner.MergeCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)2))).merge(org.mockito.Matchers.anyCollection(), org.mockito.Matchers.anyObject());
    }

    @Test
    public void testInvalidParameters() {
        DynamicProcessingTimeSessionWindows assigner;
        SessionWindowTimeGapExtractor extractor;
        WindowAssigner.WindowAssignerContext mockContext = (WindowAssigner.WindowAssignerContext)Mockito.mock(WindowAssigner.WindowAssignerContext.class);
        try {
            extractor = (SessionWindowTimeGapExtractor)Mockito.mock(SessionWindowTimeGapExtractor.class);
            Mockito.when((Object)extractor.extract(org.mockito.Matchers.any())).thenReturn((Object)-1L);
            assigner = DynamicProcessingTimeSessionWindows.withDynamicGap((SessionWindowTimeGapExtractor)extractor);
            assigner.assignWindows((Object)Lists.newArrayList((Object[])new Object[]{new Object()}), 1L, mockContext);
            Assert.fail((String)"should fail");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.toString(), (Matcher)CoreMatchers.containsString((String)"0 < gap"));
        }
        try {
            extractor = (SessionWindowTimeGapExtractor)Mockito.mock(SessionWindowTimeGapExtractor.class);
            Mockito.when((Object)extractor.extract(org.mockito.Matchers.any())).thenReturn((Object)-1L);
            assigner = DynamicProcessingTimeSessionWindows.withDynamicGap((SessionWindowTimeGapExtractor)extractor);
            assigner.assignWindows((Object)Lists.newArrayList((Object[])new Object[]{new Object()}), 1L, mockContext);
            Assert.fail((String)"should fail");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.toString(), (Matcher)CoreMatchers.containsString((String)"0 < gap"));
        }
    }

    @Test
    public void testProperties() {
        SessionWindowTimeGapExtractor extractor = (SessionWindowTimeGapExtractor)Mockito.mock(SessionWindowTimeGapExtractor.class);
        Mockito.when((Object)extractor.extract(org.mockito.Matchers.any())).thenReturn((Object)5000L);
        DynamicProcessingTimeSessionWindows assigner = DynamicProcessingTimeSessionWindows.withDynamicGap((SessionWindowTimeGapExtractor)extractor);
        Assert.assertFalse((boolean)assigner.isEventTime());
        Assert.assertEquals((Object)new TimeWindow.Serializer(), (Object)assigner.getWindowSerializer(new ExecutionConfig()));
        Assert.assertThat((Object)assigner.getDefaultTrigger((StreamExecutionEnvironment)Mockito.mock(StreamExecutionEnvironment.class)), (Matcher)Matchers.instanceOf(ProcessingTimeTrigger.class));
    }
}

