/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.sink;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.api.connector.sink.Committer;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.streaming.api.operators.OneInputStreamOperatorFactory;
import org.apache.flink.streaming.runtime.operators.sink.SinkOperatorFactory;
import org.apache.flink.streaming.runtime.operators.sink.SinkTestUtil;
import org.apache.flink.streaming.runtime.operators.sink.TestSink;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.streaming.util.TestHarnessUtil;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class StreamingCommitterHandlerTest
extends TestLogger {
    @Test(expected=IllegalStateException.class)
    public void throwExceptionWithoutSerializer() throws Exception {
        OneInputStreamOperatorTestHarness<String, byte[]> testHarness = this.createTestHarness(new TestSink.DefaultCommitter(), null);
        testHarness.initializeEmptyState();
        testHarness.open();
    }

    @Test
    public void supportRetry() throws Exception {
        List<String> input = Arrays.asList("lazy", "leaf");
        TestSink.RetryOnceCommitter committer = new TestSink.RetryOnceCommitter();
        OneInputStreamOperatorTestHarness<String, byte[]> testHarness = this.createTestHarness(committer);
        testHarness.initializeEmptyState();
        testHarness.open();
        testHarness.processElements(input.stream().map(StreamRecord::new).collect(Collectors.toList()));
        testHarness.prepareSnapshotPreBarrier(1L);
        testHarness.snapshot(1L, 1L);
        testHarness.notifyOfCompletedCheckpoint(1L);
        Assert.assertTrue((boolean)testHarness.getOutput().isEmpty());
        testHarness.snapshot(2L, 2L);
        testHarness.notifyOfCompletedCheckpoint(2L);
        MatcherAssert.assertThat(testHarness.getOutput(), (Matcher)Matchers.hasSize((int)2));
        testHarness.close();
        List committedInputs = committer.getCommittedData().stream().map(s -> s.substring(1, s.length() - 1).split(",")[0].trim()).collect(Collectors.toList());
        MatcherAssert.assertThat(committedInputs, (Matcher)Matchers.contains((Object[])new String[]{"lazy", "leaf"}));
    }

    @Test
    public void closeCommitter() throws Exception {
        TestSink.DefaultCommitter committer = new TestSink.DefaultCommitter();
        OneInputStreamOperatorTestHarness<String, byte[]> testHarness = this.createTestHarness(committer);
        testHarness.initializeEmptyState();
        testHarness.open();
        testHarness.close();
        MatcherAssert.assertThat((Object)committer.isClosed(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void restoredFromMergedState() throws Exception {
        List<String> input1 = Arrays.asList("today", "whom");
        OperatorSubtaskState operatorSubtaskState1 = TestHarnessUtil.buildSubtaskState(this.createTestHarness(), input1);
        List<String> input2 = Arrays.asList("future", "evil", "how");
        OperatorSubtaskState operatorSubtaskState2 = TestHarnessUtil.buildSubtaskState(this.createTestHarness(), input2);
        TestSink.DefaultCommitter committer = new TestSink.DefaultCommitter();
        OneInputStreamOperatorTestHarness<String, byte[]> testHarness = this.createTestHarness(committer);
        OperatorSubtaskState mergedOperatorSubtaskState = OneInputStreamOperatorTestHarness.repackageState(operatorSubtaskState1, operatorSubtaskState2);
        testHarness.initializeState(OneInputStreamOperatorTestHarness.repartitionOperatorState(mergedOperatorSubtaskState, 2, 2, 1, 0));
        testHarness.open();
        ArrayList<String> expectedOutput = new ArrayList<String>();
        expectedOutput.addAll(input1);
        expectedOutput.addAll(input2);
        testHarness.prepareSnapshotPreBarrier(1L);
        testHarness.snapshot(1L, 1L);
        testHarness.notifyOfCompletedCheckpoint(1L);
        testHarness.close();
        Object[] expectedList = (String[])expectedOutput.stream().map(output -> Tuple3.of((Object)output, null, (Object)Long.MIN_VALUE).toString()).toArray(String[]::new);
        MatcherAssert.assertThat(SinkTestUtil.fromRecords(testHarness.getRecordOutput()), (Matcher)Matchers.containsInAnyOrder((Object[])expectedList));
        MatcherAssert.assertThat(committer.getCommittedData(), (Matcher)Matchers.containsInAnyOrder((Object[])expectedList));
    }

    @Test
    public void commitMultipleStagesTogether() throws Exception {
        TestSink.DefaultCommitter committer = new TestSink.DefaultCommitter();
        List<String> input1 = Arrays.asList("cautious", "nature");
        List<String> input2 = Arrays.asList("count", "over");
        List<String> input3 = Arrays.asList("lawyer", "grammar");
        ArrayList<String> expectedOutput = new ArrayList<String>();
        expectedOutput.addAll(input1);
        expectedOutput.addAll(input2);
        expectedOutput.addAll(input3);
        OneInputStreamOperatorTestHarness<String, byte[]> testHarness = this.createTestHarness(committer);
        testHarness.initializeEmptyState();
        testHarness.open();
        testHarness.processElements(input1.stream().map(StreamRecord::new).collect(Collectors.toList()));
        testHarness.prepareSnapshotPreBarrier(1L);
        testHarness.snapshot(1L, 1L);
        testHarness.processElements(input2.stream().map(StreamRecord::new).collect(Collectors.toList()));
        testHarness.prepareSnapshotPreBarrier(2L);
        testHarness.snapshot(2L, 2L);
        testHarness.processElements(input3.stream().map(StreamRecord::new).collect(Collectors.toList()));
        testHarness.prepareSnapshotPreBarrier(3L);
        testHarness.snapshot(3L, 3L);
        testHarness.notifyOfCompletedCheckpoint(1L);
        testHarness.notifyOfCompletedCheckpoint(3L);
        testHarness.close();
        List expectedList = expectedOutput.stream().map(output -> Tuple3.of((Object)output, null, (Object)Long.MIN_VALUE).toString()).collect(Collectors.toList());
        MatcherAssert.assertThat(SinkTestUtil.fromRecords(testHarness.getRecordOutput()), (Matcher)Matchers.equalTo(expectedList));
        MatcherAssert.assertThat(committer.getCommittedData(), (Matcher)Matchers.equalTo(expectedList));
    }

    private OneInputStreamOperatorTestHarness<String, byte[]> createTestHarness() throws Exception {
        return this.createTestHarness(new TestSink.DefaultCommitter(), TestSink.StringCommittableSerializer.INSTANCE);
    }

    private OneInputStreamOperatorTestHarness<String, byte[]> createTestHarness(Committer<String> committer) throws Exception {
        return this.createTestHarness(committer, TestSink.StringCommittableSerializer.INSTANCE);
    }

    private OneInputStreamOperatorTestHarness<String, byte[]> createTestHarness(Committer<String> committer, SimpleVersionedSerializer<String> serializer) throws Exception {
        return new OneInputStreamOperatorTestHarness<String, byte[]>((OneInputStreamOperatorFactory<String, byte[]>)new SinkOperatorFactory(TestSink.newBuilder().setWriter(new TestSink.DefaultSinkWriter()).withWriterState().setCommittableSerializer(TestSink.StringCommittableSerializer.INSTANCE).setCommitter(committer).setCommittableSerializer(serializer).build(), false, true));
    }
}

