/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriter;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.event.TaskEvent;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.runtime.io.network.partition.consumer.IndexedInputGate;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;

public class MockIndexedInputGate
extends IndexedInputGate {
    private final int gateIndex;
    private final int numberOfInputChannels;

    public MockIndexedInputGate() {
        this(0, 1);
    }

    public MockIndexedInputGate(int gateIndex, int numberOfInputChannels) {
        this.gateIndex = gateIndex;
        this.numberOfInputChannels = numberOfInputChannels;
    }

    public void setup() {
    }

    public CompletableFuture<Void> getStateConsumedFuture() {
        return CompletableFuture.completedFuture(null);
    }

    public void finishReadRecoveredState() {
    }

    public void requestPartitions() {
    }

    public void resumeConsumption(InputChannelInfo channelInfo) {
    }

    public void acknowledgeAllRecordsProcessed(InputChannelInfo channelInfo) throws IOException {
        throw new UnsupportedEncodingException();
    }

    public int getNumberOfInputChannels() {
        return this.numberOfInputChannels;
    }

    public InputChannel getChannel(int channelIndex) {
        throw new UnsupportedOperationException();
    }

    public void setChannelStateWriter(ChannelStateWriter channelStateWriter) {
    }

    public List<InputChannelInfo> getChannelInfos() {
        return IntStream.range(0, this.numberOfInputChannels).mapToObj(channelIndex -> new InputChannelInfo(this.gateIndex, channelIndex)).collect(Collectors.toList());
    }

    public boolean isFinished() {
        return false;
    }

    public boolean hasReceivedEndOfData() {
        return false;
    }

    public Optional<BufferOrEvent> getNext() {
        throw new UnsupportedOperationException();
    }

    public Optional<BufferOrEvent> pollNext() {
        return this.getNext();
    }

    public void sendTaskEvent(TaskEvent event) {
    }

    public void close() {
    }

    public int getGateIndex() {
        return this.gateIndex;
    }

    public List<InputChannelInfo> getUnfinishedChannels() {
        return Collections.emptyList();
    }

    public int getBuffersInUseCount() {
        return 0;
    }

    public void announceBufferSize(int bufferSize) {
    }
}

