/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.source;

import org.apache.flink.streaming.api.operators.source.CollectingDataOutput;
import org.apache.flink.streaming.api.operators.source.WatermarkToDataOutput;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.watermarkstatus.WatermarkStatus;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class WatermarkToDataOutputTest {
    @Test
    public void testInitialZeroWatermark() {
        CollectingDataOutput testingOutput = new CollectingDataOutput();
        WatermarkToDataOutput wmOutput = new WatermarkToDataOutput(testingOutput);
        wmOutput.emitWatermark(new org.apache.flink.api.common.eventtime.Watermark(0L));
        Assert.assertThat(testingOutput.events, (Matcher)Matchers.contains((Object[])new Object[]{new Watermark(0L)}));
    }

    @Test
    public void testWatermarksDoNotRegress() {
        CollectingDataOutput testingOutput = new CollectingDataOutput();
        WatermarkToDataOutput wmOutput = new WatermarkToDataOutput(testingOutput);
        wmOutput.emitWatermark(new org.apache.flink.api.common.eventtime.Watermark(12L));
        wmOutput.emitWatermark(new org.apache.flink.api.common.eventtime.Watermark(17L));
        wmOutput.emitWatermark(new org.apache.flink.api.common.eventtime.Watermark(10L));
        wmOutput.emitWatermark(new org.apache.flink.api.common.eventtime.Watermark(18L));
        wmOutput.emitWatermark(new org.apache.flink.api.common.eventtime.Watermark(17L));
        wmOutput.emitWatermark(new org.apache.flink.api.common.eventtime.Watermark(18L));
        Assert.assertThat(testingOutput.events, (Matcher)Matchers.contains((Object[])new Object[]{new Watermark(12L), new Watermark(17L), new Watermark(18L)}));
    }

    @Test
    public void becomingActiveEmitsStatus() {
        CollectingDataOutput testingOutput = new CollectingDataOutput();
        WatermarkToDataOutput wmOutput = new WatermarkToDataOutput(testingOutput);
        wmOutput.markIdle();
        wmOutput.emitWatermark(new org.apache.flink.api.common.eventtime.Watermark(100L));
        Assert.assertThat(testingOutput.events, (Matcher)Matchers.contains((Object[])new Object[]{WatermarkStatus.IDLE, WatermarkStatus.ACTIVE, new Watermark(100L)}));
    }
}

