/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.co;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerMatchers;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerUpgradeTestBase;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.streaming.api.operators.co.BufferEntryMatchers;
import org.apache.flink.streaming.api.operators.co.IntervalJoinOperator;
import org.apache.flink.testutils.migration.MigrationVersion;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class BufferEntrySerializerUpgradeTest
extends TypeSerializerUpgradeTestBase<IntervalJoinOperator.BufferEntry<String>, IntervalJoinOperator.BufferEntry<String>> {
    public BufferEntrySerializerUpgradeTest(TypeSerializerUpgradeTestBase.TestSpecification<IntervalJoinOperator.BufferEntry<String>, IntervalJoinOperator.BufferEntry<String>> testSpecification) {
        super(testSpecification);
    }

    @Parameterized.Parameters(name="Test Specification = {0}")
    public static Collection<TypeSerializerUpgradeTestBase.TestSpecification<?, ?>> testSpecifications() throws Exception {
        ArrayList testSpecifications = new ArrayList();
        for (MigrationVersion migrationVersion : MIGRATION_VERSIONS) {
            testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("buffer-entry-serializer", migrationVersion, BufferEntrySerializerSetup.class, BufferEntrySerializerVerifier.class));
        }
        return testSpecifications;
    }

    public static final class BufferEntrySerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<IntervalJoinOperator.BufferEntry<String>> {
        public TypeSerializer<IntervalJoinOperator.BufferEntry<String>> createUpgradedSerializer() {
            return new IntervalJoinOperator.BufferEntrySerializer((TypeSerializer)StringSerializer.INSTANCE);
        }

        public Matcher<IntervalJoinOperator.BufferEntry<String>> testDataMatcher() {
            return BufferEntryMatchers.bufferEntry(Matchers.is((Object)"hello"), (Matcher<Boolean>)Matchers.is((Object)false));
        }

        public Matcher<TypeSerializerSchemaCompatibility<IntervalJoinOperator.BufferEntry<String>>> schemaCompatibilityMatcher(MigrationVersion version) {
            return TypeSerializerMatchers.isCompatibleAsIs();
        }
    }

    public static final class BufferEntrySerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<IntervalJoinOperator.BufferEntry<String>> {
        public TypeSerializer<IntervalJoinOperator.BufferEntry<String>> createPriorSerializer() {
            return new IntervalJoinOperator.BufferEntrySerializer((TypeSerializer)StringSerializer.INSTANCE);
        }

        public IntervalJoinOperator.BufferEntry<String> createTestData() {
            return new IntervalJoinOperator.BufferEntry((Object)"hello", false);
        }
    }
}

