/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.sink;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerMatchers;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerUpgradeTestBase;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.streaming.api.functions.sink.TwoPhaseCommitSinkFunction;
import org.apache.flink.testutils.migration.MigrationVersion;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TwoPhaseCommitSinkStateSerializerUpgradeTest
extends TypeSerializerUpgradeTestBase<TwoPhaseCommitSinkFunction.State<Integer, String>, TwoPhaseCommitSinkFunction.State<Integer, String>> {
    public TwoPhaseCommitSinkStateSerializerUpgradeTest(TypeSerializerUpgradeTestBase.TestSpecification<TwoPhaseCommitSinkFunction.State<Integer, String>, TwoPhaseCommitSinkFunction.State<Integer, String>> testSpecification) {
        super(testSpecification);
    }

    @Parameterized.Parameters(name="Test Specification = {0}")
    public static Collection<TypeSerializerUpgradeTestBase.TestSpecification<?, ?>> testSpecifications() throws Exception {
        ArrayList testSpecifications = new ArrayList();
        for (MigrationVersion migrationVersion : MIGRATION_VERSIONS) {
            testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("two-phase-commit-sink-state-serializer", migrationVersion, TwoPhaseCommitSinkStateSerializerSetup.class, TwoPhaseCommitSinkStateSerializerVerifier.class));
        }
        return testSpecifications;
    }

    public static TypeSerializer<TwoPhaseCommitSinkFunction.State<Integer, String>> intStringStateSerializerSupplier() {
        return new TwoPhaseCommitSinkFunction.StateSerializer((TypeSerializer)IntSerializer.INSTANCE, (TypeSerializer)StringSerializer.INSTANCE);
    }

    public static final class TwoPhaseCommitSinkStateSerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<TwoPhaseCommitSinkFunction.State<Integer, String>> {
        public TypeSerializer<TwoPhaseCommitSinkFunction.State<Integer, String>> createUpgradedSerializer() {
            return TwoPhaseCommitSinkStateSerializerUpgradeTest.intStringStateSerializerSupplier();
        }

        public Matcher<TwoPhaseCommitSinkFunction.State<Integer, String>> testDataMatcher() {
            TwoPhaseCommitSinkFunction.TransactionHolder pendingTransaction = new TwoPhaseCommitSinkFunction.TransactionHolder((Object)12, 1523467890L);
            ArrayList<TwoPhaseCommitSinkFunction.TransactionHolder> list = new ArrayList<TwoPhaseCommitSinkFunction.TransactionHolder>();
            list.add(new TwoPhaseCommitSinkFunction.TransactionHolder((Object)123, 1567234890L));
            Optional<String> optional = Optional.of("flink");
            return Matchers.is((Object)new TwoPhaseCommitSinkFunction.State(pendingTransaction, list, optional));
        }

        public Matcher<TypeSerializerSchemaCompatibility<TwoPhaseCommitSinkFunction.State<Integer, String>>> schemaCompatibilityMatcher(MigrationVersion version) {
            if (version.isNewerVersionThan(MigrationVersion.v1_13)) {
                return TypeSerializerMatchers.isCompatibleAsIs();
            }
            return TypeSerializerMatchers.isCompatibleAfterMigration();
        }
    }

    public static final class TwoPhaseCommitSinkStateSerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<TwoPhaseCommitSinkFunction.State<Integer, String>> {
        public TypeSerializer<TwoPhaseCommitSinkFunction.State<Integer, String>> createPriorSerializer() {
            return TwoPhaseCommitSinkStateSerializerUpgradeTest.intStringStateSerializerSupplier();
        }

        public TwoPhaseCommitSinkFunction.State<Integer, String> createTestData() {
            TwoPhaseCommitSinkFunction.TransactionHolder pendingTransaction = new TwoPhaseCommitSinkFunction.TransactionHolder((Object)12, 1523467890L);
            ArrayList<TwoPhaseCommitSinkFunction.TransactionHolder> list = new ArrayList<TwoPhaseCommitSinkFunction.TransactionHolder>();
            list.add(new TwoPhaseCommitSinkFunction.TransactionHolder((Object)123, 1567234890L));
            Optional<String> optional = Optional.of("flink");
            return new TwoPhaseCommitSinkFunction.State(pendingTransaction, list, optional);
        }
    }
}

