/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;

public class TestBoundedOneInputStreamOperator
extends AbstractStreamOperator<String>
implements OneInputStreamOperator<String, String>,
BoundedOneInput {
    private static final long serialVersionUID = 1L;
    private final String name;
    private static volatile boolean inputEnded = false;

    public TestBoundedOneInputStreamOperator() {
        this("test");
    }

    public TestBoundedOneInputStreamOperator(String name) {
        this.name = name;
        inputEnded = false;
    }

    public void processElement(StreamRecord<String> element) {
        this.output.collect(element);
    }

    public void endInput() {
        inputEnded = true;
        this.output("[" + this.name + "]: End of input");
    }

    public void close() throws Exception {
        ProcessingTimeService timeService = this.getProcessingTimeService();
        timeService.registerTimer(timeService.getCurrentProcessingTime(), t -> this.output("[" + this.name + "]: Timer registered in close"));
        this.output("[" + this.name + "]: Bye");
        super.close();
    }

    private void output(String record) {
        this.output.collect((Object)new StreamRecord((Object)record));
    }

    public static boolean isInputEnded() {
        return inputEnded;
    }
}

