/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util.serialize;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.net.InetSocketAddress;
import org.apache.flink.annotation.PublicEvolving;

@PublicEvolving
public class InetSocketAddressSerializer
extends Serializer<InetSocketAddress> {
    public void write(Kryo kryo, Output output, InetSocketAddress object) {
        output.writeString(object.getHostName());
        output.writeInt(object.getPort(), true);
    }

    public InetSocketAddress read(Kryo kryo, Input input, Class<? extends InetSocketAddress> type) {
        String host = input.readString();
        int port = input.readInt(true);
        return new InetSocketAddress(host, port);
    }
}

