/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.streaming.api.windowing.assigners.DynamicEventTimeSessionWindows;
import org.apache.flink.streaming.api.windowing.assigners.EventTimeSessionWindows;
import org.apache.flink.streaming.api.windowing.assigners.MergingWindowAssigner;
import org.apache.flink.streaming.api.windowing.assigners.SessionWindowTimeGapExtractor;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.triggers.EventTimeTrigger;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.hamcrest.MockitoHamcrest;
import org.mockito.verification.VerificationMode;

class EventTimeSessionWindowsTest {
    EventTimeSessionWindowsTest() {
    }

    @Test
    void testWindowAssignment() {
        int sessionGap = 5000;
        WindowAssigner.WindowAssignerContext mockContext = (WindowAssigner.WindowAssignerContext)Mockito.mock(WindowAssigner.WindowAssignerContext.class);
        EventTimeSessionWindows assigner = EventTimeSessionWindows.withGap((Duration)Duration.ofMillis(5000L));
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", 0L, mockContext)).containsExactly((Object[])new TimeWindow[]{new TimeWindow(0L, 5000L)});
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", 4999L, mockContext)).containsExactly((Object[])new TimeWindow[]{new TimeWindow(4999L, 9999L)});
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", 5000L, mockContext)).containsExactly((Object[])new TimeWindow[]{new TimeWindow(5000L, 10000L)});
    }

    @Test
    void testMergeSinglePointWindow() {
        MergingWindowAssigner.MergeCallback callback = (MergingWindowAssigner.MergeCallback)Mockito.mock(MergingWindowAssigner.MergeCallback.class);
        EventTimeSessionWindows assigner = EventTimeSessionWindows.withGap((Duration)Duration.ofMillis(5000L));
        assigner.mergeWindows(Collections.singletonList(new TimeWindow(0L, 0L)), callback);
        ((MergingWindowAssigner.MergeCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.never())).merge(ArgumentMatchers.anyCollection(), ArgumentMatchers.any());
    }

    @Test
    void testMergeSingleWindow() {
        MergingWindowAssigner.MergeCallback callback = (MergingWindowAssigner.MergeCallback)Mockito.mock(MergingWindowAssigner.MergeCallback.class);
        EventTimeSessionWindows assigner = EventTimeSessionWindows.withGap((Duration)Duration.ofMillis(5000L));
        assigner.mergeWindows(Collections.singletonList(new TimeWindow(0L, 1L)), callback);
        ((MergingWindowAssigner.MergeCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.never())).merge(ArgumentMatchers.anyCollection(), ArgumentMatchers.any());
    }

    @Test
    void testMergeConsecutiveWindows() {
        MergingWindowAssigner.MergeCallback callback = (MergingWindowAssigner.MergeCallback)Mockito.mock(MergingWindowAssigner.MergeCallback.class);
        EventTimeSessionWindows assigner = EventTimeSessionWindows.withGap((Duration)Duration.ofMillis(5000L));
        assigner.mergeWindows(Arrays.asList(new TimeWindow(0L, 1L), new TimeWindow(1L, 2L), new TimeWindow(2L, 3L), new TimeWindow(4L, 5L), new TimeWindow(5L, 6L)), callback);
        ((MergingWindowAssigner.MergeCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).merge((Collection)MockitoHamcrest.argThat((Matcher)Matchers.containsInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(0L, 1L), new TimeWindow(1L, 2L), new TimeWindow(2L, 3L)})), Mockito.eq((Object)new TimeWindow(0L, 3L)));
        ((MergingWindowAssigner.MergeCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).merge((Collection)MockitoHamcrest.argThat((Matcher)Matchers.containsInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(4L, 5L), new TimeWindow(5L, 6L)})), Mockito.eq((Object)new TimeWindow(4L, 6L)));
        ((MergingWindowAssigner.MergeCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)2))).merge(ArgumentMatchers.anyCollection(), ArgumentMatchers.any());
    }

    @Test
    void testMergeCoveringWindow() {
        MergingWindowAssigner.MergeCallback callback = (MergingWindowAssigner.MergeCallback)Mockito.mock(MergingWindowAssigner.MergeCallback.class);
        EventTimeSessionWindows assigner = EventTimeSessionWindows.withGap((Duration)Duration.ofMillis(5000L));
        assigner.mergeWindows(Arrays.asList(new TimeWindow(1L, 1L), new TimeWindow(0L, 2L), new TimeWindow(4L, 7L), new TimeWindow(5L, 6L)), callback);
        ((MergingWindowAssigner.MergeCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).merge((Collection)MockitoHamcrest.argThat((Matcher)Matchers.containsInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(1L, 1L), new TimeWindow(0L, 2L)})), Mockito.eq((Object)new TimeWindow(0L, 2L)));
        ((MergingWindowAssigner.MergeCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).merge((Collection)MockitoHamcrest.argThat((Matcher)Matchers.containsInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(5L, 6L), new TimeWindow(4L, 7L)})), Mockito.eq((Object)new TimeWindow(4L, 7L)));
        ((MergingWindowAssigner.MergeCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)2))).merge(ArgumentMatchers.anyCollection(), ArgumentMatchers.any());
    }

    @Test
    void testTimeUnits() {
        int sessionGap = 5000;
        WindowAssigner.WindowAssignerContext mockContext = (WindowAssigner.WindowAssignerContext)Mockito.mock(WindowAssigner.WindowAssignerContext.class);
        EventTimeSessionWindows assigner = EventTimeSessionWindows.withGap((Duration)Duration.ofSeconds(5L));
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", 0L, mockContext)).containsExactly((Object[])new TimeWindow[]{new TimeWindow(0L, 5000L)});
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", 4999L, mockContext)).containsExactly((Object[])new TimeWindow[]{new TimeWindow(4999L, 9999L)});
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", 5000L, mockContext)).containsExactly((Object[])new TimeWindow[]{new TimeWindow(5000L, 10000L)});
    }

    @Test
    void testInvalidParameters() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> EventTimeSessionWindows.withGap((Duration)Duration.ofSeconds(-1L))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("0 < size");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> EventTimeSessionWindows.withGap((Duration)Duration.ofSeconds(0L))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("0 < size");
    }

    @Test
    void testProperties() {
        EventTimeSessionWindows assigner = EventTimeSessionWindows.withGap((Duration)Duration.ofSeconds(5L));
        Assertions.assertThat((boolean)assigner.isEventTime()).isTrue();
        Assertions.assertThat((Object)assigner.getWindowSerializer(new ExecutionConfig())).isEqualTo((Object)new TimeWindow.Serializer());
        Assertions.assertThat((Object)assigner.getDefaultTrigger()).isInstanceOf(EventTimeTrigger.class);
    }

    @Test
    void testDynamicGapProperties() {
        SessionWindowTimeGapExtractor extractor = (SessionWindowTimeGapExtractor)Mockito.mock(SessionWindowTimeGapExtractor.class);
        DynamicEventTimeSessionWindows assigner = EventTimeSessionWindows.withDynamicGap((SessionWindowTimeGapExtractor)extractor);
        Assertions.assertThat((Object)assigner).isNotNull();
        Assertions.assertThat((boolean)assigner.isEventTime()).isTrue();
    }
}

