/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.async;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.JobInfo;
import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.accumulators.DoubleCounter;
import org.apache.flink.api.common.accumulators.Histogram;
import org.apache.flink.api.common.accumulators.IntCounter;
import org.apache.flink.api.common.accumulators.LongCounter;
import org.apache.flink.api.common.aggregators.Aggregator;
import org.apache.flink.api.common.cache.DistributedCache;
import org.apache.flink.api.common.externalresource.ExternalResourceInfo;
import org.apache.flink.api.common.functions.AbstractRichFunction;
import org.apache.flink.api.common.functions.BroadcastVariableInitializer;
import org.apache.flink.api.common.functions.IterationRuntimeContext;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.state.AggregatingState;
import org.apache.flink.api.common.state.AggregatingStateDescriptor;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.ReducingState;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.metrics.groups.OperatorMetricGroup;
import org.apache.flink.streaming.api.functions.async.AsyncFunction;
import org.apache.flink.streaming.api.functions.async.ResultFuture;
import org.apache.flink.types.Value;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public abstract class RichAsyncFunction<IN, OUT>
extends AbstractRichFunction
implements AsyncFunction<IN, OUT> {
    private static final long serialVersionUID = 3858030061138121840L;

    public void setRuntimeContext(RuntimeContext runtimeContext) {
        Preconditions.checkNotNull((Object)runtimeContext);
        if (runtimeContext instanceof IterationRuntimeContext) {
            super.setRuntimeContext((RuntimeContext)new RichAsyncFunctionIterationRuntimeContext((IterationRuntimeContext)runtimeContext));
        } else {
            super.setRuntimeContext((RuntimeContext)new RichAsyncFunctionRuntimeContext(runtimeContext));
        }
    }

    @Override
    public abstract void asyncInvoke(IN var1, ResultFuture<OUT> var2) throws Exception;

    private static class RichAsyncFunctionIterationRuntimeContext
    extends RichAsyncFunctionRuntimeContext
    implements IterationRuntimeContext {
        private final IterationRuntimeContext iterationRuntimeContext;

        RichAsyncFunctionIterationRuntimeContext(IterationRuntimeContext iterationRuntimeContext) {
            super((RuntimeContext)iterationRuntimeContext);
            this.iterationRuntimeContext = (IterationRuntimeContext)Preconditions.checkNotNull((Object)iterationRuntimeContext);
        }

        public int getSuperstepNumber() {
            return this.iterationRuntimeContext.getSuperstepNumber();
        }

        public <T extends Aggregator<?>> T getIterationAggregator(String name) {
            throw new UnsupportedOperationException("Iteration aggregators are not supported in rich async functions.");
        }

        public <T extends Value> T getPreviousIterationAggregate(String name) {
            throw new UnsupportedOperationException("Iteration aggregators are not supported in rich async functions.");
        }
    }

    private static class RichAsyncFunctionRuntimeContext
    implements RuntimeContext {
        private final RuntimeContext runtimeContext;

        RichAsyncFunctionRuntimeContext(RuntimeContext context) {
            this.runtimeContext = (RuntimeContext)Preconditions.checkNotNull((Object)context);
        }

        public OperatorMetricGroup getMetricGroup() {
            return this.runtimeContext.getMetricGroup();
        }

        public <T> TypeSerializer<T> createSerializer(TypeInformation<T> typeInformation) {
            return this.runtimeContext.createSerializer(typeInformation);
        }

        public Map<String, String> getGlobalJobParameters() {
            return this.runtimeContext.getGlobalJobParameters();
        }

        public boolean isObjectReuseEnabled() {
            return this.runtimeContext.isObjectReuseEnabled();
        }

        public ClassLoader getUserCodeClassLoader() {
            return this.runtimeContext.getUserCodeClassLoader();
        }

        public void registerUserCodeClassLoaderReleaseHookIfAbsent(String releaseHookName, Runnable releaseHook) {
            this.runtimeContext.registerUserCodeClassLoaderReleaseHookIfAbsent(releaseHookName, releaseHook);
        }

        public Set<ExternalResourceInfo> getExternalResourceInfos(String resourceName) {
            return this.runtimeContext.getExternalResourceInfos(resourceName);
        }

        public DistributedCache getDistributedCache() {
            throw new UnsupportedOperationException("Distributed cache is not supported in rich async functions.");
        }

        public <T> ValueState<T> getState(ValueStateDescriptor<T> stateProperties) {
            throw new UnsupportedOperationException("State is not supported in rich async functions.");
        }

        public <T> ListState<T> getListState(ListStateDescriptor<T> stateProperties) {
            throw new UnsupportedOperationException("State is not supported in rich async functions.");
        }

        public <T> ReducingState<T> getReducingState(ReducingStateDescriptor<T> stateProperties) {
            throw new UnsupportedOperationException("State is not supported in rich async functions.");
        }

        public <IN, ACC, OUT> AggregatingState<IN, OUT> getAggregatingState(AggregatingStateDescriptor<IN, ACC, OUT> stateProperties) {
            throw new UnsupportedOperationException("State is not supported in rich async functions.");
        }

        public <UK, UV> MapState<UK, UV> getMapState(MapStateDescriptor<UK, UV> stateProperties) {
            throw new UnsupportedOperationException("State is not supported in rich async functions.");
        }

        public <V, A extends Serializable> void addAccumulator(String name, Accumulator<V, A> accumulator) {
            throw new UnsupportedOperationException("Accumulators are not supported in rich async functions.");
        }

        public <V, A extends Serializable> Accumulator<V, A> getAccumulator(String name) {
            throw new UnsupportedOperationException("Accumulators are not supported in rich async functions.");
        }

        public IntCounter getIntCounter(String name) {
            throw new UnsupportedOperationException("Int counters are not supported in rich async functions.");
        }

        public LongCounter getLongCounter(String name) {
            throw new UnsupportedOperationException("Long counters are not supported in rich async functions.");
        }

        public DoubleCounter getDoubleCounter(String name) {
            throw new UnsupportedOperationException("Double counters are not supported in rich async functions.");
        }

        public Histogram getHistogram(String name) {
            throw new UnsupportedOperationException("Histograms are not supported in rich async functions.");
        }

        public boolean hasBroadcastVariable(String name) {
            throw new UnsupportedOperationException("Broadcast variables are not supported in rich async functions.");
        }

        public <RT> List<RT> getBroadcastVariable(String name) {
            throw new UnsupportedOperationException("Broadcast variables are not supported in rich async functions.");
        }

        public <T, C> C getBroadcastVariableWithInitializer(String name, BroadcastVariableInitializer<T, C> initializer) {
            throw new UnsupportedOperationException("Broadcast variables are not supported in rich async functions.");
        }

        public JobInfo getJobInfo() {
            return this.runtimeContext.getJobInfo();
        }

        public TaskInfo getTaskInfo() {
            return this.runtimeContext.getTaskInfo();
        }
    }
}

