/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import org.apache.flink.streaming.api.operators.InputSelection;
import org.apache.flink.streaming.runtime.io.MultipleInputSelectionHandler;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MultipleInputSelectionHandlerTest {
    MultipleInputSelectionHandlerTest() {
    }

    @Test
    void testShouldSetAvailableForAnotherInput() {
        InputSelection secondAndThird = new InputSelection.Builder().select(2).select(3).build();
        MultipleInputSelectionHandler selectionHandler = new MultipleInputSelectionHandler(() -> secondAndThird, 3);
        selectionHandler.nextSelection();
        Assertions.assertThat((boolean)selectionHandler.shouldSetAvailableForAnotherInput()).isFalse();
        selectionHandler.setUnavailableInput(0);
        Assertions.assertThat((boolean)selectionHandler.shouldSetAvailableForAnotherInput()).isFalse();
        selectionHandler.setUnavailableInput(2);
        Assertions.assertThat((boolean)selectionHandler.shouldSetAvailableForAnotherInput()).isTrue();
        selectionHandler.setAvailableInput(0);
        Assertions.assertThat((boolean)selectionHandler.shouldSetAvailableForAnotherInput()).isTrue();
        selectionHandler.setAvailableInput(2);
        Assertions.assertThat((boolean)selectionHandler.shouldSetAvailableForAnotherInput()).isFalse();
    }

    @Test
    void testLargeInputCount() {
        int inputCount = 63;
        InputSelection.Builder builder = new InputSelection.Builder();
        for (int i = 1; i <= inputCount; ++i) {
            builder.select(i);
        }
        InputSelection allSelected = builder.build();
        MultipleInputSelectionHandler selectionHandler = new MultipleInputSelectionHandler(() -> allSelected, inputCount);
        selectionHandler.nextSelection();
        for (int i = 0; i < inputCount - 1; ++i) {
            selectionHandler.setUnavailableInput(i);
        }
        Assertions.assertThat((boolean)selectionHandler.isAnyInputAvailable()).isTrue();
        selectionHandler.setUnavailableInput(inputCount - 1);
        Assertions.assertThat((boolean)selectionHandler.isAnyInputAvailable()).isFalse();
    }
}

