/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util.retryable;

import org.apache.flink.streaming.util.retryable.AsyncRetryStrategies;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class AsyncRetryStrategiesTest
extends TestLogger {
    @Test
    public void testExponentialBackoffDelayRetryStrategy() {
        int maxAttempts = 10;
        long initialDelay = 100L;
        long maxRetryDelay = 2000L;
        double multiplier = 2.0;
        AsyncRetryStrategies.ExponentialBackoffDelayRetryStrategy exponentialBackoffDelayRetryStrategy = new AsyncRetryStrategies.ExponentialBackoffDelayRetryStrategyBuilder(maxAttempts, initialDelay, maxRetryDelay, multiplier).build();
        Assert.assertTrue((boolean)exponentialBackoffDelayRetryStrategy.canRetry(maxAttempts));
        Assert.assertFalse((boolean)exponentialBackoffDelayRetryStrategy.canRetry(maxAttempts + 1));
        for (int j = 1; j <= 5; ++j) {
            long currentDelay = initialDelay;
            for (int i = 1; i <= maxAttempts; ++i) {
                Assert.assertEquals((long)currentDelay, (long)exponentialBackoffDelayRetryStrategy.getBackoffTimeMillis(i));
                currentDelay = Math.min((long)((double)currentDelay * multiplier), maxRetryDelay);
            }
        }
    }
}

