/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.streamrecord;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerMatchers;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerUpgradeTestBase;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.streaming.runtime.streamrecord.StreamElement;
import org.apache.flink.streaming.runtime.streamrecord.StreamElementSerializer;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.StreamRecordMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

class StreamElementSerializerUpgradeTest
extends TypeSerializerUpgradeTestBase<StreamElement, StreamElement> {
    StreamElementSerializerUpgradeTest() {
    }

    public Collection<TypeSerializerUpgradeTestBase.TestSpecification<?, ?>> createTestSpecifications(FlinkVersion flinkVersion) throws Exception {
        ArrayList testSpecifications = new ArrayList();
        testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("stream-element-serializer", flinkVersion, StreamElementSetup.class, StreamElementVerifier.class));
        return testSpecifications;
    }

    public static final class StreamElementVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<StreamElement> {
        public TypeSerializer<StreamElement> createUpgradedSerializer() {
            return new StreamElementSerializer((TypeSerializer)StringSerializer.INSTANCE);
        }

        public Matcher<StreamElement> testDataMatcher() {
            return StreamRecordMatchers.streamRecord(Matchers.is((Object)"key"), (Matcher<? super Long>)Matchers.is((Object)123456L));
        }

        public Matcher<TypeSerializerSchemaCompatibility<StreamElement>> schemaCompatibilityMatcher(FlinkVersion version) {
            return TypeSerializerMatchers.isCompatibleAsIs();
        }
    }

    public static final class StreamElementSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<StreamElement> {
        public TypeSerializer<StreamElement> createPriorSerializer() {
            return new StreamElementSerializer((TypeSerializer)StringSerializer.INSTANCE);
        }

        public StreamElement createTestData() {
            return new StreamRecord((Object)"key", 123456L);
        }
    }
}

