/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.partitioner;

import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.streaming.runtime.partitioner.RebalancePartitioner;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitionerTest;
import org.junit.Assert;
import org.junit.Test;

public class RebalancePartitionerTest
extends StreamPartitionerTest {
    @Override
    public StreamPartitioner<Tuple> createPartitioner() {
        RebalancePartitioner partitioner = new RebalancePartitioner();
        Assert.assertFalse((boolean)partitioner.isBroadcast());
        return partitioner;
    }

    @Test
    public void testSelectChannelsInterval() {
        int numberOfChannels = 3;
        this.streamPartitioner.setup(3);
        int initialChannel = this.streamPartitioner.selectChannel((IOReadableWritable)this.serializationDelegate);
        Assert.assertTrue((0 <= initialChannel ? 1 : 0) != 0);
        Assert.assertTrue((3 > initialChannel ? 1 : 0) != 0);
        for (int i = 1; i <= 3; ++i) {
            this.assertSelectedChannel((initialChannel + i) % 3);
        }
    }
}

