/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import org.apache.flink.streaming.runtime.operators.windowing.KeyMap;
import org.junit.Assert;
import org.junit.Test;

public class KeyMapPutIfAbsentTest {
    @Test
    public void testPutIfAbsentUniqueKeysAndGrowth() {
        try {
            int i;
            KeyMap map = new KeyMap();
            IntegerFactory factory = new IntegerFactory();
            int numElements = 1000000;
            for (i = 0; i < 1000000; ++i) {
                factory.set(2 * i + 1);
                map.putIfAbsent((Object)i, (KeyMap.LazyFactory)factory);
                Assert.assertEquals((long)(i + 1), (long)map.size());
                Assert.assertTrue((map.getCurrentTableCapacity() > map.size() ? 1 : 0) != 0);
                Assert.assertTrue((map.getCurrentTableCapacity() > map.getRehashThreshold() ? 1 : 0) != 0);
                Assert.assertTrue((map.size() <= map.getRehashThreshold() ? 1 : 0) != 0);
            }
            Assert.assertEquals((long)1000000L, (long)map.size());
            Assert.assertEquals((long)1000000L, (long)map.traverseAndCountElements());
            Assert.assertEquals((long)0x200000L, (long)map.getCurrentTableCapacity());
            for (i = 0; i < 1000000; ++i) {
                Assert.assertEquals((long)(2 * i + 1), (long)((Integer)map.get((Object)i)).intValue());
            }
            for (i = 999999; i >= 0; --i) {
                Assert.assertEquals((long)(2 * i + 1), (long)((Integer)map.get((Object)i)).intValue());
            }
            Assert.assertEquals((long)1000000L, (long)map.size());
            Assert.assertEquals((long)1000000L, (long)map.traverseAndCountElements());
            Assert.assertEquals((long)0x200000L, (long)map.getCurrentTableCapacity());
            Assert.assertTrue((map.getLongestChainLength() <= 7 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testPutIfAbsentDuplicateKeysAndGrowth() {
        try {
            int i;
            KeyMap map = new KeyMap();
            IntegerFactory factory = new IntegerFactory();
            int numElements = 1000000;
            for (i = 0; i < 1000000; ++i) {
                int val = 2 * i + 1;
                factory.set(val);
                Integer put = (Integer)map.putIfAbsent((Object)i, (KeyMap.LazyFactory)factory);
                Assert.assertEquals((long)val, (long)put.intValue());
            }
            for (i = 0; i < 1000000; i += 3) {
                factory.set(2 * i);
                Integer put = (Integer)map.putIfAbsent((Object)i, (KeyMap.LazyFactory)factory);
                Assert.assertEquals((long)(2 * i + 1), (long)put.intValue());
            }
            for (i = 0; i < 1000000; ++i) {
                Assert.assertEquals((long)(2 * i + 1), (long)((Integer)map.get((Object)i)).intValue());
            }
            Assert.assertEquals((long)1000000L, (long)map.size());
            Assert.assertEquals((long)1000000L, (long)map.traverseAndCountElements());
            Assert.assertEquals((long)0x200000L, (long)map.getCurrentTableCapacity());
            Assert.assertTrue((map.getLongestChainLength() <= 7 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private static class IntegerFactory
    implements KeyMap.LazyFactory<Integer> {
        private Integer toCreate;

        private IntegerFactory() {
        }

        public void set(Integer toCreate) {
            this.toCreate = toCreate;
        }

        public Integer create() {
            return this.toCreate;
        }
    }
}

