/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.sink.committables;

import java.util.Collection;
import org.apache.flink.metrics.groups.SinkCommitterMetricGroup;
import org.apache.flink.runtime.metrics.groups.MetricsGroupTestUtils;
import org.apache.flink.streaming.api.connector.sink2.CommittableMessage;
import org.apache.flink.streaming.api.connector.sink2.CommittableSummary;
import org.apache.flink.streaming.api.connector.sink2.SinkV2Assertions;
import org.apache.flink.streaming.runtime.operators.sink.committables.CommittableCollector;
import org.apache.flink.streaming.runtime.operators.sink.committables.CommittableManager;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class CommittableCollectorTest {
    private static final SinkCommitterMetricGroup METRIC_GROUP = MetricsGroupTestUtils.mockCommitterMetricGroup();

    CommittableCollectorTest() {
    }

    @Test
    void testGetCheckpointCommittablesUpTo() {
        CommittableCollector committableCollector = new CommittableCollector(1, 1, METRIC_GROUP);
        CommittableSummary first = new CommittableSummary(1, 1, Long.valueOf(1L), 1, 0, 0);
        committableCollector.addMessage((CommittableMessage)first);
        CommittableSummary second = new CommittableSummary(1, 1, Long.valueOf(2L), 1, 0, 0);
        committableCollector.addMessage((CommittableMessage)second);
        committableCollector.addMessage((CommittableMessage)new CommittableSummary(1, 1, Long.valueOf(3L), 1, 0, 0));
        Assertions.assertThat((Collection)committableCollector.getCheckpointCommittablesUpTo(2L)).hasSize(2);
        Assertions.assertThat((Object)committableCollector.getEndOfInputCommittable()).isNull();
    }

    @Test
    void testGetEndOfInputCommittable() {
        CommittableCollector committableCollector = new CommittableCollector(1, 1, METRIC_GROUP);
        CommittableSummary first = new CommittableSummary(1, 1, null, 1, 0, 0);
        committableCollector.addMessage((CommittableMessage)first);
        CommittableManager endOfInputCommittable = committableCollector.getEndOfInputCommittable();
        Assertions.assertThat((Object)endOfInputCommittable).isNotNull();
        SinkV2Assertions.assertThat(endOfInputCommittable.getSummary()).hasCheckpointId(Long.MAX_VALUE);
    }
}

