/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import java.io.Serializable;
import java.time.Duration;
import org.apache.flink.api.common.functions.CoGroupFunction;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.streaming.api.datastream.CoGroupedStreams;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.windowing.assigners.TumblingEventTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CoGroupedStreamsTest {
    private DataStream<String> dataStream1;
    private DataStream<String> dataStream2;
    private KeySelector<String, String> keySelector;
    private TumblingEventTimeWindows tsAssigner;
    private CoGroupFunction<String, String, String> coGroupFunction;

    @Before
    public void setUp() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        this.dataStream1 = env.fromData((Object[])new String[]{"a1", "a2", "a3"});
        this.dataStream2 = env.fromData((Object[])new String[]{"a1", "a2"});
        this.keySelector = (KeySelector & Serializable)element -> element;
        this.tsAssigner = TumblingEventTimeWindows.of((Duration)Duration.ofMillis(1L));
        this.coGroupFunction = (CoGroupFunction & Serializable)(first, second, out) -> out.collect((Object)"");
    }

    @Test
    public void testDelegateToCoGrouped() {
        Duration lateness = Duration.ofMillis(42L);
        CoGroupedStreams.WithWindow withLateness = this.dataStream1.coGroup(this.dataStream2).where(this.keySelector).equalTo(this.keySelector).window((WindowAssigner)this.tsAssigner).allowedLateness(lateness);
        withLateness.apply(this.coGroupFunction, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO);
        Assert.assertEquals((long)lateness.toMillis(), (long)withLateness.getWindowedStream().getAllowedLateness());
    }

    @Test
    public void testSetAllowedLateness() {
        Duration lateness = Duration.ofMillis(42L);
        CoGroupedStreams.WithWindow withLateness = this.dataStream1.coGroup(this.dataStream2).where(this.keySelector).equalTo(this.keySelector).window((WindowAssigner)this.tsAssigner).allowedLateness(lateness);
        Assert.assertEquals((Object)lateness, withLateness.getAllowedLatenessDuration().orElse(null));
    }
}

