/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.BoundedMultiInput;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;

public class TestBoundedTwoInputOperator
extends AbstractStreamOperator<String>
implements TwoInputStreamOperator<String, String, String>,
BoundedMultiInput {
    private static final long serialVersionUID = 1L;
    private final String name;

    public TestBoundedTwoInputOperator(String name) {
        this.name = name;
    }

    public void processElement1(StreamRecord<String> element) {
        this.output.collect((Object)element.replace((Object)("[" + this.name + "-1]: " + (String)element.getValue())));
    }

    public void processElement2(StreamRecord<String> element) {
        this.output.collect((Object)element.replace((Object)("[" + this.name + "-2]: " + (String)element.getValue())));
    }

    public void endInput(int inputId) {
        this.output("[" + this.name + "-" + inputId + "]: End of input");
    }

    public void finish() throws Exception {
        ProcessingTimeService timeService = this.getProcessingTimeService();
        timeService.registerTimer(timeService.getCurrentProcessingTime(), t -> this.output("[" + this.name + "]: Timer registered in close"));
        this.output.collect((Object)new StreamRecord((Object)("[" + this.name + "]: Finish")));
        super.finish();
    }

    private void output(String record) {
        this.output.collect((Object)new StreamRecord((Object)record));
    }
}

