/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.shaded.guava31.com.google.common.collect.Lists;
import org.apache.flink.streaming.api.windowing.triggers.EventTimeTrigger;
import org.apache.flink.streaming.api.windowing.triggers.TriggerResult;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.apache.flink.streaming.runtime.operators.windowing.TriggerTestHarness;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.junit.Assert;
import org.junit.Test;

public class EventTimeTriggerTest {
    @Test
    public void testWindowSeparationAndFiring() throws Exception {
        TriggerTestHarness testHarness = new TriggerTestHarness(EventTimeTrigger.create(), (TypeSerializer<TimeWindow>)new TimeWindow.Serializer());
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L)));
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L)));
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L)));
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(2L, 4L)));
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(2L, 4L)));
        Assert.assertEquals((long)0L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)0L, (long)testHarness.numProcessingTimeTimers());
        Assert.assertEquals((long)2L, (long)testHarness.numEventTimeTimers());
        Assert.assertEquals((long)1L, (long)testHarness.numEventTimeTimers(new TimeWindow(0L, 2L)));
        Assert.assertEquals((long)1L, (long)testHarness.numEventTimeTimers(new TimeWindow(2L, 4L)));
        Assert.assertEquals((Object)TriggerResult.FIRE, (Object)testHarness.advanceWatermark(2L, new TimeWindow(0L, 2L)));
        Assert.assertEquals((long)0L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)0L, (long)testHarness.numProcessingTimeTimers());
        Assert.assertEquals((long)1L, (long)testHarness.numEventTimeTimers());
        Assert.assertEquals((long)0L, (long)testHarness.numEventTimeTimers(new TimeWindow(0L, 2L)));
        Assert.assertEquals((long)1L, (long)testHarness.numEventTimeTimers(new TimeWindow(2L, 4L)));
        Assert.assertEquals((Object)TriggerResult.FIRE, (Object)testHarness.advanceWatermark(4L, new TimeWindow(2L, 4L)));
        Assert.assertEquals((long)0L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)0L, (long)testHarness.numProcessingTimeTimers());
        Assert.assertEquals((long)0L, (long)testHarness.numEventTimeTimers());
    }

    @Test
    public void testLateElementTriggersImmediately() throws Exception {
        TriggerTestHarness testHarness = new TriggerTestHarness(EventTimeTrigger.create(), (TypeSerializer<TimeWindow>)new TimeWindow.Serializer());
        testHarness.advanceWatermark(2L);
        Assert.assertEquals((Object)TriggerResult.FIRE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L)));
        Assert.assertEquals((long)0L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)0L, (long)testHarness.numProcessingTimeTimers());
        Assert.assertEquals((long)0L, (long)testHarness.numEventTimeTimers());
    }

    @Test
    public void testClear() throws Exception {
        TriggerTestHarness testHarness = new TriggerTestHarness(EventTimeTrigger.create(), (TypeSerializer<TimeWindow>)new TimeWindow.Serializer());
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L)));
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(2L, 4L)));
        Assert.assertEquals((long)0L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)0L, (long)testHarness.numProcessingTimeTimers());
        Assert.assertEquals((long)2L, (long)testHarness.numEventTimeTimers());
        Assert.assertEquals((long)1L, (long)testHarness.numEventTimeTimers(new TimeWindow(0L, 2L)));
        Assert.assertEquals((long)1L, (long)testHarness.numEventTimeTimers(new TimeWindow(2L, 4L)));
        testHarness.clearTriggerState(new TimeWindow(2L, 4L));
        Assert.assertEquals((long)0L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)0L, (long)testHarness.numProcessingTimeTimers());
        Assert.assertEquals((long)1L, (long)testHarness.numEventTimeTimers());
        Assert.assertEquals((long)1L, (long)testHarness.numEventTimeTimers(new TimeWindow(0L, 2L)));
        Assert.assertEquals((long)0L, (long)testHarness.numEventTimeTimers(new TimeWindow(2L, 4L)));
        testHarness.clearTriggerState(new TimeWindow(0L, 2L));
        Assert.assertEquals((long)0L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)0L, (long)testHarness.numProcessingTimeTimers());
        Assert.assertEquals((long)0L, (long)testHarness.numEventTimeTimers());
    }

    @Test
    public void testMergingWindows() throws Exception {
        TriggerTestHarness testHarness = new TriggerTestHarness(EventTimeTrigger.create(), (TypeSerializer<TimeWindow>)new TimeWindow.Serializer());
        Assert.assertTrue((boolean)EventTimeTrigger.create().canMerge());
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L)));
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(2L, 4L)));
        Assert.assertEquals((long)0L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)0L, (long)testHarness.numProcessingTimeTimers());
        Assert.assertEquals((long)2L, (long)testHarness.numEventTimeTimers());
        Assert.assertEquals((long)1L, (long)testHarness.numEventTimeTimers(new TimeWindow(0L, 2L)));
        Assert.assertEquals((long)1L, (long)testHarness.numEventTimeTimers(new TimeWindow(2L, 4L)));
        testHarness.mergeWindows(new TimeWindow(0L, 4L), Lists.newArrayList((Object[])new TimeWindow[]{new TimeWindow(0L, 2L), new TimeWindow(2L, 4L)}));
        Assert.assertEquals((long)0L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)0L, (long)testHarness.numProcessingTimeTimers());
        Assert.assertEquals((long)1L, (long)testHarness.numEventTimeTimers());
        Assert.assertEquals((long)0L, (long)testHarness.numEventTimeTimers(new TimeWindow(0L, 2L)));
        Assert.assertEquals((long)0L, (long)testHarness.numEventTimeTimers(new TimeWindow(2L, 4L)));
        Assert.assertEquals((long)1L, (long)testHarness.numEventTimeTimers(new TimeWindow(0L, 4L)));
        Assert.assertEquals((Object)TriggerResult.FIRE, (Object)testHarness.advanceWatermark(4L, new TimeWindow(0L, 4L)));
        Assert.assertEquals((long)0L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)0L, (long)testHarness.numProcessingTimeTimers());
        Assert.assertEquals((long)0L, (long)testHarness.numEventTimeTimers());
    }

    @Test
    public void testMergingLateWindows() throws Exception {
        TriggerTestHarness testHarness = new TriggerTestHarness(EventTimeTrigger.create(), (TypeSerializer<TimeWindow>)new TimeWindow.Serializer());
        Assert.assertTrue((boolean)EventTimeTrigger.create().canMerge());
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L)));
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(2L, 4L)));
        Assert.assertEquals((long)0L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)0L, (long)testHarness.numProcessingTimeTimers());
        Assert.assertEquals((long)2L, (long)testHarness.numEventTimeTimers());
        Assert.assertEquals((long)1L, (long)testHarness.numEventTimeTimers(new TimeWindow(0L, 2L)));
        Assert.assertEquals((long)1L, (long)testHarness.numEventTimeTimers(new TimeWindow(2L, 4L)));
        testHarness.advanceWatermark(10L);
        Assert.assertEquals((long)0L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)0L, (long)testHarness.numProcessingTimeTimers());
        Assert.assertEquals((long)0L, (long)testHarness.numEventTimeTimers());
        Assert.assertEquals((long)0L, (long)testHarness.numEventTimeTimers(new TimeWindow(0L, 2L)));
        Assert.assertEquals((long)0L, (long)testHarness.numEventTimeTimers(new TimeWindow(2L, 4L)));
        testHarness.mergeWindows(new TimeWindow(0L, 4L), Lists.newArrayList((Object[])new TimeWindow[]{new TimeWindow(0L, 2L), new TimeWindow(2L, 4L)}));
        Assert.assertEquals((long)0L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)0L, (long)testHarness.numProcessingTimeTimers());
        Assert.assertEquals((long)0L, (long)testHarness.numEventTimeTimers());
        Assert.assertEquals((long)0L, (long)testHarness.numEventTimeTimers(new TimeWindow(0L, 2L)));
        Assert.assertEquals((long)0L, (long)testHarness.numEventTimeTimers(new TimeWindow(2L, 4L)));
        Assert.assertEquals((long)0L, (long)testHarness.numEventTimeTimers(new TimeWindow(0L, 4L)));
    }
}

