/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api.input.operator.window;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.state.api.functions.WindowReaderFunction;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;

@Internal
public abstract class EvictingWindowReaderFunction<IN, R, OUT, KEY, W extends Window>
extends WindowReaderFunction<StreamRecord<IN>, OUT, KEY, W> {
    private final WindowReaderFunction<R, OUT, KEY, W> wrappedFunction;

    protected EvictingWindowReaderFunction(WindowReaderFunction<R, OUT, KEY, W> wrappedFunction) {
        this.wrappedFunction = (WindowReaderFunction)((Object)Preconditions.checkNotNull(wrappedFunction, (String)"Inner reader function cannot be null"));
    }

    public void open(OpenContext openContext) throws Exception {
        FunctionUtils.openFunction(this.wrappedFunction, (OpenContext)openContext);
    }

    public void close() throws Exception {
        FunctionUtils.closeFunction(this.wrappedFunction);
    }

    public void setRuntimeContext(RuntimeContext t) {
        super.setRuntimeContext(t);
        FunctionUtils.setFunctionRuntimeContext(this.wrappedFunction, (RuntimeContext)t);
    }

    @Override
    public void readWindow(KEY key, WindowReaderFunction.Context<W> context, Iterable<StreamRecord<IN>> elements, Collector<OUT> out) throws Exception {
        Iterable<R> result = this.transform(elements);
        this.wrappedFunction.readWindow(key, context, result, out);
    }

    public abstract Iterable<R> transform(Iterable<StreamRecord<IN>> var1) throws Exception;
}

