/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api.input;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.Preconditions;

@Internal
public final class MultiStateKeyIterator<K>
implements CloseableIterator<K> {
    private final List<? extends StateDescriptor<?, ?>> descriptors;
    private final Iterator<K> iterator;
    private final CloseableRegistry registry;

    public MultiStateKeyIterator(List<? extends StateDescriptor<?, ?>> descriptors, KeyedStateBackend<K> backend) {
        this.descriptors = (List)Preconditions.checkNotNull(descriptors);
        Preconditions.checkNotNull(backend);
        this.registry = new CloseableRegistry();
        Stream stream = backend.getKeys(this.descriptors.stream().map(StateDescriptor::getName).collect(Collectors.toList()), (Object)VoidNamespace.INSTANCE);
        try {
            this.registry.registerCloseable(stream::close);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read keys from configured StateBackend", e);
        }
        this.iterator = stream.iterator();
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public K next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.iterator.next();
    }

    public void close() throws Exception {
        this.registry.close();
    }
}

