/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.state.api.runtime.OperatorIDGenerator;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

@PublicEvolving
public final class OperatorIdentifier
implements Serializable {
    @Nullable
    private final String uid;
    private final OperatorID operatorId;

    private OperatorIdentifier(OperatorID operatorId, @Nullable String uid) {
        this.operatorId = operatorId;
        this.uid = uid;
    }

    public static OperatorIdentifier forUidHash(String uidHash) {
        Preconditions.checkNotNull((Object)uidHash);
        return new OperatorIdentifier(new OperatorID(StringUtils.hexStringToByte((String)uidHash)), null);
    }

    public static OperatorIdentifier forUid(String uid) {
        Preconditions.checkNotNull((Object)uid);
        return new OperatorIdentifier(OperatorIDGenerator.fromUid(uid), uid);
    }

    @Internal
    public Optional<String> getUid() {
        return Optional.ofNullable(this.uid);
    }

    @Internal
    public OperatorID getOperatorId() {
        return this.operatorId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperatorIdentifier that = (OperatorIdentifier)o;
        return Objects.equals(this.operatorId, that.operatorId);
    }

    public int hashCode() {
        return Objects.hash(this.operatorId);
    }

    public String toString() {
        return this.uid != null ? this.uid + "(" + this.operatorId.toHexString() + ")" : this.operatorId.toHexString();
    }
}

