/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api.output.operators;

import java.util.function.Supplier;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.streaming.api.TimerService;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;

@Internal
public class LazyTimerService
implements TimerService {
    private final Supplier<InternalTimerService<VoidNamespace>> supplier;
    private final ProcessingTimeService processingTimeService;
    private InternalTimerService<VoidNamespace> internalTimerService;

    LazyTimerService(Supplier<InternalTimerService<VoidNamespace>> supplier, ProcessingTimeService processingTimeService) {
        this.supplier = supplier;
        this.processingTimeService = processingTimeService;
    }

    public long currentProcessingTime() {
        return this.processingTimeService.getCurrentProcessingTime();
    }

    public long currentWatermark() {
        return Long.MIN_VALUE;
    }

    public void registerProcessingTimeTimer(long time) {
        this.ensureInitialized();
        this.internalTimerService.registerProcessingTimeTimer((Object)VoidNamespace.INSTANCE, time);
    }

    public void registerEventTimeTimer(long time) {
        this.ensureInitialized();
        this.internalTimerService.registerEventTimeTimer((Object)VoidNamespace.INSTANCE, time);
    }

    public void deleteProcessingTimeTimer(long time) {
        this.ensureInitialized();
        this.internalTimerService.deleteProcessingTimeTimer((Object)VoidNamespace.INSTANCE, time);
    }

    public void deleteEventTimeTimer(long time) {
        this.ensureInitialized();
        this.internalTimerService.deleteEventTimeTimer((Object)VoidNamespace.INSTANCE, time);
    }

    private void ensureInitialized() {
        if (this.internalTimerService == null) {
            this.internalTimerService = this.supplier.get();
        }
    }
}

