/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api.output;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.core.execution.SavepointFormatType;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.SavepointType;
import org.apache.flink.runtime.checkpoint.SnapshotType;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.filesystem.AbstractFsCheckpointStorageAccess;
import org.apache.flink.runtime.state.filesystem.FsCheckpointStorageLocation;
import org.apache.flink.state.api.output.TaggedOperatorSubtaskState;
import org.apache.flink.streaming.api.operators.OperatorSnapshotFinalizer;
import org.apache.flink.streaming.api.operators.OperatorSnapshotFutures;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.util.MathUtils;

@Internal
public final class SnapshotUtils {
    private SnapshotUtils() {
    }

    public static <OUT, OP extends StreamOperator<OUT>> TaggedOperatorSubtaskState snapshot(long checkpointId, OP operator, int index, long timestamp, boolean isExactlyOnceMode, boolean isUnalignedCheckpoint, Configuration configuration, Path savepointPath, SavepointFormatType savepointFormatType) throws Exception {
        CheckpointOptions options = CheckpointOptions.forConfig((SnapshotType)SavepointType.savepoint((SavepointFormatType)savepointFormatType), (CheckpointStorageLocationReference)AbstractFsCheckpointStorageAccess.encodePathAsReference((Path)savepointPath), (boolean)isExactlyOnceMode, (boolean)isUnalignedCheckpoint, (long)Long.MAX_VALUE);
        operator.prepareSnapshotPreBarrier(checkpointId);
        CheckpointStreamFactory storage = SnapshotUtils.createStreamFactory(configuration, options);
        OperatorSnapshotFutures snapshotInProgress = operator.snapshotState(checkpointId, timestamp, options, storage);
        OperatorSubtaskState state = new OperatorSnapshotFinalizer(snapshotInProgress).getJobManagerOwnedState();
        operator.notifyCheckpointComplete(checkpointId);
        return new TaggedOperatorSubtaskState(index, state);
    }

    public static <OUT, OP extends StreamOperator<OUT>> TaggedOperatorSubtaskState snapshot(long checkpointId, OP operator, int index, long timestamp, boolean isExactlyOnceMode, boolean isUnalignedCheckpoint, Configuration configuration, Path savepointPath) throws Exception {
        return SnapshotUtils.snapshot(checkpointId, operator, index, timestamp, isExactlyOnceMode, isUnalignedCheckpoint, configuration, savepointPath, SavepointFormatType.DEFAULT);
    }

    private static CheckpointStreamFactory createStreamFactory(Configuration configuration, CheckpointOptions options) throws IOException {
        Path path = AbstractFsCheckpointStorageAccess.decodePathFromReference((CheckpointStorageLocationReference)options.getTargetLocation());
        return new FsCheckpointStorageLocation(path.getFileSystem(), path, path, path, options.getTargetLocation(), MathUtils.checkedDownCast((long)((MemorySize)configuration.get(CheckpointingOptions.FS_SMALL_FILE_THRESHOLD)).getBytes()), ((Integer)configuration.get(CheckpointingOptions.FS_WRITE_BUFFER_SIZE)).intValue());
    }
}

