/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.protobuf;

import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.formats.protobuf.PbFormatConfig;
import org.apache.flink.formats.protobuf.serialize.PbRowDataSerializationSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;

public class PbEncodingFormat
implements EncodingFormat<SerializationSchema<RowData>> {
    private final PbFormatConfig pbFormatConfig;

    public PbEncodingFormat(PbFormatConfig pbFormatConfig) {
        this.pbFormatConfig = pbFormatConfig;
    }

    public ChangelogMode getChangelogMode() {
        return ChangelogMode.insertOnly();
    }

    public SerializationSchema<RowData> createRuntimeEncoder(DynamicTableSink.Context context, DataType consumedDataType) {
        RowType rowType = (RowType)consumedDataType.getLogicalType();
        return new PbRowDataSerializationSchema(rowType, this.pbFormatConfig);
    }
}

