/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl.resource;

import java.util.List;
import javax.annotation.Nonnull;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;

public class SqlResource
extends SqlCall {
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("SqlResource", SqlKind.OTHER);
    private final SqlLiteral resourceType;
    private final SqlCharStringLiteral resourcePath;

    public SqlResource(SqlParserPos pos, SqlLiteral resourceType, SqlCharStringLiteral resourcePath) {
        super(pos);
        this.resourceType = resourceType;
        this.resourcePath = resourcePath;
    }

    @Nonnull
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Nonnull
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.resourceType, (Object)this.resourcePath);
    }

    public SqlLiteral getResourceType() {
        return this.resourceType;
    }

    public SqlCharStringLiteral getResourcePath() {
        return this.resourcePath;
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        this.resourceType.unparse(writer, leftPrec, rightPrec);
        this.resourcePath.unparse(writer, leftPrec, rightPrec);
    }
}

