/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.flink.sql.parser.ExtendedSqlNode;
import org.apache.flink.sql.parser.error.SqlValidateException;

public class SqlTableLike
extends SqlCall
implements ExtendedSqlNode {
    private final SqlIdentifier sourceTable;
    private final List<SqlTableLikeOption> options;
    private static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("LIKE TABLE", SqlKind.OTHER);
    private static final Map<FeatureOption, List<MergingStrategy>> invalidCombinations = new HashMap<FeatureOption, List<MergingStrategy>>();

    public SqlTableLike(SqlParserPos pos, SqlIdentifier sourceTable, List<SqlTableLikeOption> options) {
        super(pos);
        this.sourceTable = sourceTable;
        this.options = options;
    }

    @Nonnull
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Nonnull
    public List<SqlNode> getOperandList() {
        return Collections.singletonList(this.sourceTable);
    }

    public SqlIdentifier getSourceTable() {
        return this.sourceTable;
    }

    public List<SqlTableLikeOption> getOptions() {
        return this.options;
    }

    @Override
    public void validate() throws SqlValidateException {
        long distinctFeatures = this.options.stream().map(SqlTableLikeOption::getFeatureOption).distinct().count();
        if (distinctFeatures != (long)this.options.size()) {
            throw new SqlValidateException(this.pos, "Each like option feature can be declared only once.");
        }
        for (SqlTableLikeOption option : this.options) {
            if (!invalidCombinations.getOrDefault((Object)option.featureOption, Collections.emptyList()).contains((Object)option.mergingStrategy)) continue;
            throw new SqlValidateException(this.pos, String.format("Illegal merging strategy '%s' for '%s' option.", new Object[]{option.getMergingStrategy(), option.getFeatureOption()}));
        }
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("LIKE");
        this.sourceTable.unparse(writer, leftPrec, rightPrec);
        if (this.options == null || this.options.isEmpty()) {
            return;
        }
        SqlWriter.Frame frame = writer.startList("(", ")");
        for (SqlTableLikeOption option : this.options) {
            writer.newlineAndIndent();
            writer.print("  ");
            writer.keyword(option.mergingStrategy.toString());
            writer.keyword(option.featureOption.toString());
        }
        writer.newlineAndIndent();
        writer.endList(frame);
    }

    static {
        invalidCombinations.put(FeatureOption.ALL, Collections.singletonList(MergingStrategy.OVERWRITING));
        invalidCombinations.put(FeatureOption.PARTITIONS, Collections.singletonList(MergingStrategy.OVERWRITING));
        invalidCombinations.put(FeatureOption.CONSTRAINTS, Collections.singletonList(MergingStrategy.OVERWRITING));
    }

    public static class SqlTableLikeOption {
        private final MergingStrategy mergingStrategy;
        private final FeatureOption featureOption;

        public SqlTableLikeOption(MergingStrategy mergingStrategy, FeatureOption featureOption) {
            this.mergingStrategy = mergingStrategy;
            this.featureOption = featureOption;
        }

        public MergingStrategy getMergingStrategy() {
            return this.mergingStrategy;
        }

        public FeatureOption getFeatureOption() {
            return this.featureOption;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SqlTableLikeOption that = (SqlTableLikeOption)o;
            return this.mergingStrategy == that.mergingStrategy && this.featureOption == that.featureOption;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.mergingStrategy, this.featureOption});
        }

        public String toString() {
            return String.format("%s %s", new Object[]{this.mergingStrategy, this.featureOption});
        }
    }

    public static enum FeatureOption {
        ALL,
        CONSTRAINTS,
        GENERATED,
        METADATA,
        OPTIONS,
        PARTITIONS,
        WATERMARKS;

    }

    public static enum MergingStrategy {
        INCLUDING,
        EXCLUDING,
        OVERWRITING;

    }
}

