/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.flink.sql.parser.ddl.SqlCreateTable;
import org.apache.flink.sql.parser.ddl.SqlWatermark;
import org.apache.flink.sql.parser.ddl.constraint.SqlTableConstraint;
import org.apache.flink.sql.parser.error.SqlValidateException;

public class SqlCreateTableAs
extends SqlCreateTable {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("CREATE TABLE AS", SqlKind.CREATE_TABLE);
    private final SqlNode asQuery;

    public SqlCreateTableAs(SqlParserPos pos, SqlIdentifier tableName, SqlNodeList columnList, List<SqlTableConstraint> tableConstraints, SqlNodeList propertyList, SqlNodeList partitionKeyList, @Nullable SqlWatermark watermark, @Nullable SqlCharStringLiteral comment, SqlNode asQuery, boolean isTemporary, boolean ifNotExists) {
        super(OPERATOR, pos, tableName, columnList, tableConstraints, propertyList, partitionKeyList, watermark, comment, isTemporary, ifNotExists);
        this.asQuery = Objects.requireNonNull(asQuery, "As clause is required for CREATE TABLE AS SELECT DDL");
    }

    @Override
    @Nonnull
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    @Nonnull
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.builder().addAll(super.getOperandList()).add((Object)this.asQuery).build();
    }

    @Override
    public void validate() throws SqlValidateException {
        super.validate();
        if (this.isTemporary()) {
            throw new SqlValidateException(this.getParserPosition(), "CREATE TABLE AS SELECT syntax does not support to create temporary table yet.");
        }
        if (this.getColumnList().size() > 0) {
            throw new SqlValidateException(this.getParserPosition(), "CREATE TABLE AS SELECT syntax does not support to specify explicit columns yet.");
        }
        if (this.getWatermark().isPresent()) {
            throw new SqlValidateException(this.getParserPosition(), "CREATE TABLE AS SELECT syntax does not support to specify explicit watermark yet.");
        }
        if (this.getPartitionKeyList().size() > 0) {
            throw new SqlValidateException(this.getParserPosition(), "CREATE TABLE AS SELECT syntax does not support to create partitioned table yet.");
        }
        if (this.getFullConstraints().stream().anyMatch(SqlTableConstraint::isPrimaryKey)) {
            throw new SqlValidateException(this.getParserPosition(), "CREATE TABLE AS SELECT syntax does not support primary key constraints yet.");
        }
    }

    public SqlNode getAsQuery() {
        return this.asQuery;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        super.unparse(writer, leftPrec, rightPrec);
        writer.newlineAndIndent();
        writer.keyword("AS");
        writer.newlineAndIndent();
        this.asQuery.unparse(writer, leftPrec, rightPrec);
    }
}

