/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.parquet.utils;

import org.apache.flink.formats.parquet.vector.position.CollectionPosition;
import org.apache.flink.formats.parquet.vector.position.RowPosition;
import org.apache.flink.formats.parquet.vector.type.ParquetField;
import org.apache.flink.runtime.util.BooleanArrayList;
import org.apache.flink.runtime.util.LongArrayList;

public class NestedPositionUtil {
    public static RowPosition calculateRowOffsets(ParquetField field, int[] fieldDefinitionLevels, int[] fieldRepetitionLevels) {
        int rowDefinitionLevel = field.getDefinitionLevel();
        int rowRepetitionLevel = field.getRepetitionLevel();
        int nullValuesCount = 0;
        BooleanArrayList nullRowFlags = new BooleanArrayList(0);
        for (int i = 0; i < fieldDefinitionLevels.length; ++i) {
            if (fieldRepetitionLevels[i] > rowRepetitionLevel) continue;
            if (fieldDefinitionLevels[i] >= rowDefinitionLevel) {
                nullRowFlags.add(false);
                continue;
            }
            nullRowFlags.add(true);
            ++nullValuesCount;
        }
        if (nullValuesCount == 0) {
            return new RowPosition(null, fieldDefinitionLevels.length);
        }
        return new RowPosition(nullRowFlags.toArray(), nullRowFlags.size());
    }

    public static CollectionPosition calculateCollectionOffsets(ParquetField field, int[] definitionLevels, int[] repetitionLevels) {
        int collectionDefinitionLevel = field.getDefinitionLevel();
        int collectionRepetitionLevel = field.getRepetitionLevel() + 1;
        int offset = 0;
        int valueCount = 0;
        LongArrayList offsets = new LongArrayList(0);
        offsets.add((long)offset);
        BooleanArrayList emptyCollectionFlags = new BooleanArrayList(0);
        BooleanArrayList nullCollectionFlags = new BooleanArrayList(0);
        int nullValuesCount = 0;
        int i = 0;
        while (i < definitionLevels.length) {
            ++valueCount;
            if (definitionLevels[i] >= collectionDefinitionLevel - 1) {
                boolean isNull = NestedPositionUtil.isOptionalFieldValueNull(definitionLevels[i], collectionDefinitionLevel);
                nullCollectionFlags.add(isNull);
                nullValuesCount += isNull ? 1 : 0;
                if (definitionLevels[i] > collectionDefinitionLevel) {
                    emptyCollectionFlags.add(false);
                    offset += NestedPositionUtil.getCollectionSize(repetitionLevels, collectionRepetitionLevel, i + 1);
                } else if (definitionLevels[i] == collectionDefinitionLevel) {
                    ++offset;
                    emptyCollectionFlags.add(true);
                } else {
                    ++offset;
                    emptyCollectionFlags.add(false);
                }
                offsets.add((long)offset);
            } else {
                nullCollectionFlags.add(true);
                ++nullValuesCount;
                offsets.add((long)(++offset));
                emptyCollectionFlags.add(false);
            }
            i = NestedPositionUtil.getNextCollectionStartIndex(repetitionLevels, collectionRepetitionLevel, i);
        }
        long[] offsetsArray = offsets.toArray();
        long[] length = NestedPositionUtil.calculateLengthByOffsets(emptyCollectionFlags.toArray(), offsetsArray);
        if (nullValuesCount == 0) {
            return new CollectionPosition(null, offsetsArray, length, valueCount);
        }
        return new CollectionPosition(nullCollectionFlags.toArray(), offsetsArray, length, valueCount);
    }

    public static boolean isOptionalFieldValueNull(int definitionLevel, int maxDefinitionLevel) {
        return definitionLevel == maxDefinitionLevel - 1;
    }

    public static long[] calculateLengthByOffsets(boolean[] collectionIsEmpty, long[] arrayOffsets) {
        LongArrayList lengthList = new LongArrayList(arrayOffsets.length);
        for (int i = 0; i < arrayOffsets.length - 1; ++i) {
            long offset = arrayOffsets[i];
            long length = arrayOffsets[i + 1] - offset;
            if (length < 0L) {
                throw new IllegalArgumentException(String.format("Offset is not monotonically ascending. offsets[%s]=%s, offsets[%s]=%s", i, arrayOffsets[i], i + 1, arrayOffsets[i + 1]));
            }
            if (collectionIsEmpty[i]) {
                length = 0L;
            }
            lengthList.add(length);
        }
        return lengthList.toArray();
    }

    private static int getNextCollectionStartIndex(int[] repetitionLevels, int maxRepetitionLevel, int elementIndex) {
        while (NestedPositionUtil.hasMoreElements(repetitionLevels, ++elementIndex) && NestedPositionUtil.isNotCollectionBeginningMarker(repetitionLevels, maxRepetitionLevel, elementIndex)) {
        }
        return elementIndex;
    }

    private static int getCollectionSize(int[] repetitionLevels, int maxRepetitionLevel, int nextIndex) {
        int size = 1;
        while (NestedPositionUtil.hasMoreElements(repetitionLevels, nextIndex) && NestedPositionUtil.isNotCollectionBeginningMarker(repetitionLevels, maxRepetitionLevel, nextIndex)) {
            if (repetitionLevels[nextIndex] <= maxRepetitionLevel) {
                ++size;
            }
            ++nextIndex;
        }
        return size;
    }

    private static boolean isNotCollectionBeginningMarker(int[] repetitionLevels, int maxRepetitionLevel, int nextIndex) {
        return repetitionLevels[nextIndex] >= maxRepetitionLevel;
    }

    private static boolean hasMoreElements(int[] repetitionLevels, int nextIndex) {
        return nextIndex < repetitionLevels.length;
    }
}

