/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.parquet.vector.reader;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.formats.parquet.utils.NestedPositionUtil;
import org.apache.flink.formats.parquet.vector.position.CollectionPosition;
import org.apache.flink.formats.parquet.vector.position.LevelDelegation;
import org.apache.flink.formats.parquet.vector.position.RowPosition;
import org.apache.flink.formats.parquet.vector.reader.ColumnReader;
import org.apache.flink.formats.parquet.vector.reader.NestedPrimitiveColumnReader;
import org.apache.flink.formats.parquet.vector.type.ParquetField;
import org.apache.flink.formats.parquet.vector.type.ParquetGroupField;
import org.apache.flink.formats.parquet.vector.type.ParquetPrimitiveField;
import org.apache.flink.table.data.columnar.vector.ColumnVector;
import org.apache.flink.table.data.columnar.vector.heap.AbstractHeapVector;
import org.apache.flink.table.data.columnar.vector.heap.HeapArrayVector;
import org.apache.flink.table.data.columnar.vector.heap.HeapMapVector;
import org.apache.flink.table.data.columnar.vector.heap.HeapRowVector;
import org.apache.flink.table.data.columnar.vector.writable.WritableColumnVector;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.page.PageReadStore;

public class NestedColumnReader
implements ColumnReader<WritableColumnVector> {
    private final Map<ColumnDescriptor, NestedPrimitiveColumnReader> columnReaders;
    private final boolean isUtcTimestamp;
    private final PageReadStore pages;
    private final ParquetField field;

    public NestedColumnReader(boolean isUtcTimestamp, PageReadStore pages, ParquetField field) {
        this.isUtcTimestamp = isUtcTimestamp;
        this.pages = pages;
        this.field = field;
        this.columnReaders = new HashMap<ColumnDescriptor, NestedPrimitiveColumnReader>();
    }

    @Override
    public void readToVector(int readNumber, WritableColumnVector vector) throws IOException {
        this.readData(this.field, readNumber, (ColumnVector)vector, false);
    }

    private Tuple2<LevelDelegation, WritableColumnVector> readData(ParquetField field, int readNumber, ColumnVector vector, boolean inside) throws IOException {
        if (field.getType() instanceof RowType) {
            return this.readRow((ParquetGroupField)field, readNumber, vector, inside);
        }
        if (field.getType() instanceof MapType || field.getType() instanceof MultisetType) {
            return this.readMap((ParquetGroupField)field, readNumber, vector, inside);
        }
        if (field.getType() instanceof ArrayType) {
            return this.readArray((ParquetGroupField)field, readNumber, vector, inside);
        }
        return this.readPrimitive((ParquetPrimitiveField)field, readNumber, vector);
    }

    private Tuple2<LevelDelegation, WritableColumnVector> readRow(ParquetGroupField field, int readNumber, ColumnVector vector, boolean inside) throws IOException {
        HeapRowVector heapRowVector = (HeapRowVector)vector;
        LevelDelegation levelDelegation = null;
        List<ParquetField> children = field.getChildren();
        WritableColumnVector[] childrenVectors = heapRowVector.getFields();
        WritableColumnVector[] finalChildrenVectors = new WritableColumnVector[childrenVectors.length];
        for (int i = 0; i < children.size(); ++i) {
            Tuple2<LevelDelegation, WritableColumnVector> tuple = this.readData(children.get(i), readNumber, (ColumnVector)childrenVectors[i], true);
            levelDelegation = (LevelDelegation)tuple.f0;
            finalChildrenVectors[i] = (WritableColumnVector)tuple.f1;
        }
        if (levelDelegation == null) {
            throw new FlinkRuntimeException(String.format("Row field does not have any children: %s.", field));
        }
        RowPosition rowPosition = NestedPositionUtil.calculateRowOffsets(field, levelDelegation.getDefinitionLevel(), levelDelegation.getRepetitionLevel());
        if (inside) {
            heapRowVector = new HeapRowVector(rowPosition.getPositionsCount(), finalChildrenVectors);
        } else {
            heapRowVector.setFields(finalChildrenVectors);
        }
        if (rowPosition.getIsNull() != null) {
            NestedColumnReader.setFieldNullFalg(rowPosition.getIsNull(), (AbstractHeapVector)heapRowVector);
        }
        return Tuple2.of((Object)levelDelegation, (Object)heapRowVector);
    }

    private Tuple2<LevelDelegation, WritableColumnVector> readMap(ParquetGroupField field, int readNumber, ColumnVector vector, boolean inside) throws IOException {
        HeapMapVector mapVector = (HeapMapVector)vector;
        mapVector.reset();
        List<ParquetField> children = field.getChildren();
        Preconditions.checkArgument((children.size() == 2 ? 1 : 0) != 0, (String)"Maps must have two type parameters, found %s", (Object[])new Object[]{children.size()});
        Tuple2<LevelDelegation, WritableColumnVector> keyTuple = this.readData(children.get(0), readNumber, mapVector.getKeyColumnVector(), true);
        Tuple2<LevelDelegation, WritableColumnVector> valueTuple = this.readData(children.get(1), readNumber, mapVector.getValueColumnVector(), true);
        LevelDelegation levelDelegation = (LevelDelegation)keyTuple.f0;
        CollectionPosition collectionPosition = NestedPositionUtil.calculateCollectionOffsets(field, levelDelegation.getDefinitionLevel(), levelDelegation.getRepetitionLevel());
        if (inside) {
            mapVector = new HeapMapVector(collectionPosition.getValueCount(), (ColumnVector)keyTuple.f1, (ColumnVector)valueTuple.f1);
        } else {
            mapVector.setKeys((ColumnVector)keyTuple.f1);
            mapVector.setValues((ColumnVector)valueTuple.f1);
        }
        if (collectionPosition.getIsNull() != null) {
            NestedColumnReader.setFieldNullFalg(collectionPosition.getIsNull(), (AbstractHeapVector)mapVector);
        }
        mapVector.setLengths(collectionPosition.getLength());
        mapVector.setOffsets(collectionPosition.getOffsets());
        return Tuple2.of((Object)levelDelegation, (Object)mapVector);
    }

    private Tuple2<LevelDelegation, WritableColumnVector> readArray(ParquetGroupField field, int readNumber, ColumnVector vector, boolean inside) throws IOException {
        HeapArrayVector arrayVector = (HeapArrayVector)vector;
        arrayVector.reset();
        List<ParquetField> children = field.getChildren();
        Preconditions.checkArgument((children.size() == 1 ? 1 : 0) != 0, (String)"Arrays must have a single type parameter, found %s", (Object[])new Object[]{children.size()});
        Tuple2<LevelDelegation, WritableColumnVector> tuple = this.readData(children.get(0), readNumber, arrayVector.getChild(), true);
        LevelDelegation levelDelegation = (LevelDelegation)tuple.f0;
        CollectionPosition collectionPosition = NestedPositionUtil.calculateCollectionOffsets(field, levelDelegation.getDefinitionLevel(), levelDelegation.getRepetitionLevel());
        if (inside) {
            arrayVector = new HeapArrayVector(collectionPosition.getValueCount(), (ColumnVector)tuple.f1);
        } else {
            arrayVector.setChild((ColumnVector)tuple.f1);
        }
        if (collectionPosition.getIsNull() != null) {
            NestedColumnReader.setFieldNullFalg(collectionPosition.getIsNull(), (AbstractHeapVector)arrayVector);
        }
        arrayVector.setLengths(collectionPosition.getLength());
        arrayVector.setOffsets(collectionPosition.getOffsets());
        return Tuple2.of((Object)levelDelegation, (Object)arrayVector);
    }

    private Tuple2<LevelDelegation, WritableColumnVector> readPrimitive(ParquetPrimitiveField field, int readNumber, ColumnVector vector) throws IOException {
        ColumnDescriptor descriptor = field.getDescriptor();
        NestedPrimitiveColumnReader reader = this.columnReaders.get(descriptor);
        if (reader == null) {
            reader = new NestedPrimitiveColumnReader(descriptor, this.pages.getPageReader(descriptor), this.isUtcTimestamp, descriptor.getPrimitiveType(), field.getType());
            this.columnReaders.put(descriptor, reader);
        }
        WritableColumnVector writableColumnVector = reader.readAndNewVector(readNumber, (WritableColumnVector)vector);
        return Tuple2.of((Object)reader.getLevelDelegation(), (Object)writableColumnVector);
    }

    private static void setFieldNullFalg(boolean[] nullFlags, AbstractHeapVector vector) {
        for (int index = 0; index < vector.getLen() && index < nullFlags.length; ++index) {
            if (!nullFlags[index]) continue;
            vector.setNullAt(index);
        }
    }
}

