/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.parquet;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.connector.file.table.factories.BulkReaderFormatFactory;
import org.apache.flink.connector.file.table.factories.BulkWriterFormatFactory;
import org.apache.flink.connector.file.table.format.BulkDecodingFormat;
import org.apache.flink.core.fs.Path;
import org.apache.flink.formats.parquet.ParquetColumnarRowInputFormat;
import org.apache.flink.formats.parquet.row.ParquetRowDataBuilder;
import org.apache.flink.formats.parquet.utils.ParquetFormatStatisticsReportUtil;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.Projection;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.format.FileBasedStatisticsReportableInputFormat;
import org.apache.flink.table.connector.format.ProjectableDecodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;

public class ParquetFileFormatFactory
implements BulkReaderFormatFactory,
BulkWriterFormatFactory {
    public static final String IDENTIFIER = "parquet";
    public static final ConfigOption<Boolean> UTC_TIMEZONE = ConfigOptions.key((String)"utc-timezone").booleanType().defaultValue((Object)false).withDescription("Use UTC timezone or local timezone to the conversion between epoch time and LocalDateTime. Hive 0.x/1.x/2.x use local timezone. But Hive 3.x use UTC timezone");
    public static final ConfigOption<String> TIMESTAMP_TIME_UNIT = ConfigOptions.key((String)"timestamp.time.unit").stringType().defaultValue((Object)"micros").withDescription("Store parquet int64/LogicalTypes timestamps in this time unit, value is nanos/micros/millis");
    public static final ConfigOption<Boolean> WRITE_INT64_TIMESTAMP = ConfigOptions.key((String)"write.int64.timestamp").booleanType().defaultValue((Object)false).withDescription("Write parquet timestamp as int64/LogicalTypes instead of int96/OriginalTypes. Note: Timestamp will be time zone agnostic (NEVER converted to a different time zone).");
    public static final ConfigOption<Integer> BATCH_SIZE = ConfigOptions.key((String)"batch-size").intType().defaultValue((Object)2048).withDescription("Determine the batch size when reading parquet files.");

    public BulkDecodingFormat<RowData> createDecodingFormat(DynamicTableFactory.Context context, ReadableConfig formatOptions) {
        return new ParquetBulkDecodingFormat(formatOptions);
    }

    public EncodingFormat<BulkWriter.Factory<RowData>> createEncodingFormat(DynamicTableFactory.Context context, final ReadableConfig formatOptions) {
        return new EncodingFormat<BulkWriter.Factory<RowData>>(){

            public BulkWriter.Factory<RowData> createRuntimeEncoder(DynamicTableSink.Context sinkContext, DataType consumedDataType) {
                return ParquetRowDataBuilder.createWriterFactory((RowType)consumedDataType.getLogicalType(), ParquetFileFormatFactory.getParquetConfiguration(formatOptions), (Boolean)formatOptions.get(UTC_TIMEZONE));
            }

            public ChangelogMode getChangelogMode() {
                return ChangelogMode.insertOnly();
            }
        };
    }

    private static org.apache.hadoop.conf.Configuration getParquetConfiguration(ReadableConfig options) {
        org.apache.hadoop.conf.Configuration conf = new org.apache.hadoop.conf.Configuration();
        Properties properties = new Properties();
        ((Configuration)options).addAllToProperties(properties);
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> conf.set("parquet." + k, v.toString())));
        return conf;
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return new HashSet();
    }

    public Set<ConfigOption<?>> optionalOptions() {
        return new HashSet();
    }

    @VisibleForTesting
    public static class ParquetBulkDecodingFormat
    implements ProjectableDecodingFormat<BulkFormat<RowData, FileSourceSplit>>,
    BulkDecodingFormat<RowData>,
    FileBasedStatisticsReportableInputFormat {
        private final ReadableConfig formatOptions;

        public ParquetBulkDecodingFormat(ReadableConfig formatOptions) {
            this.formatOptions = formatOptions;
        }

        public BulkFormat<RowData, FileSourceSplit> createRuntimeDecoder(DynamicTableSource.Context sourceContext, DataType producedDataType, int[][] projections) {
            return ParquetColumnarRowInputFormat.createPartitionedFormat(ParquetFileFormatFactory.getParquetConfiguration(this.formatOptions), (RowType)Projection.of((int[][])projections).project(producedDataType).getLogicalType(), (TypeInformation<RowData>)sourceContext.createTypeInformation(producedDataType), Collections.emptyList(), null, (Integer)this.formatOptions.get(BATCH_SIZE), (Boolean)this.formatOptions.get(UTC_TIMEZONE), true);
        }

        public ChangelogMode getChangelogMode() {
            return ChangelogMode.insertOnly();
        }

        public TableStats reportStatistics(List<Path> files, DataType producedDataType) {
            return ParquetFormatStatisticsReportUtil.getTableStatistics(files, producedDataType, ParquetFileFormatFactory.getParquetConfiguration(this.formatOptions), (Boolean)this.formatOptions.get(UTC_TIMEZONE));
        }
    }
}

