/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import java.util.Arrays;
import java.util.Collection;
import java.util.NoSuchElementException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.runtime.state.InternalPriorityQueue;
import org.apache.flink.runtime.state.heap.HeapPriorityQueueElement;
import org.apache.flink.util.CloseableIterator;

public abstract class AbstractHeapPriorityQueue<T extends HeapPriorityQueueElement>
implements InternalPriorityQueue<T> {
    @Nonnull
    protected T[] queue;
    @Nonnegative
    protected int size;

    public AbstractHeapPriorityQueue(@Nonnegative int minimumCapacity) {
        this.queue = new HeapPriorityQueueElement[this.getHeadElementIndex() + minimumCapacity];
        this.size = 0;
    }

    @Override
    @Nullable
    public T poll() {
        return this.size() > 0 ? (T)this.removeInternal(this.getHeadElementIndex()) : null;
    }

    @Override
    @Nullable
    public T peek() {
        return this.queue[this.getHeadElementIndex()];
    }

    @Override
    public boolean add(@Nonnull T toAdd) {
        this.addInternal(toAdd);
        return toAdd.getInternalIndex() == this.getHeadElementIndex();
    }

    @Override
    public boolean remove(@Nonnull T toRemove) {
        int elementIndex = toRemove.getInternalIndex();
        this.removeInternal(elementIndex);
        return elementIndex == this.getHeadElementIndex();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void addAll(@Nullable Collection<? extends T> toAdd) {
        if (toAdd == null) {
            return;
        }
        this.resizeForBulkLoad(toAdd.size());
        for (HeapPriorityQueueElement element : toAdd) {
            this.add((T)element);
        }
    }

    @Nonnull
    public <O> O[] toArray(O[] out) {
        int heapArrayOffset = this.getHeadElementIndex();
        if (out.length < this.size) {
            return Arrays.copyOfRange(this.queue, heapArrayOffset, heapArrayOffset + this.size, out.getClass());
        }
        System.arraycopy(this.queue, heapArrayOffset, out, 0, this.size);
        if (out.length > this.size) {
            out[this.size] = null;
        }
        return out;
    }

    @Override
    @Nonnull
    public CloseableIterator<T> iterator() {
        return new HeapIterator();
    }

    public void clear() {
        int arrayOffset = this.getHeadElementIndex();
        Arrays.fill(this.queue, arrayOffset, arrayOffset + this.size, null);
        this.size = 0;
    }

    protected void resizeForBulkLoad(int totalSize) {
        if (totalSize > this.queue.length) {
            int desiredSize = totalSize + (totalSize >>> 3);
            this.resizeQueueArray(desiredSize, totalSize);
        }
    }

    protected void resizeQueueArray(int desiredSize, int minRequiredSize) {
        if (AbstractHeapPriorityQueue.isValidArraySize(desiredSize)) {
            this.queue = (HeapPriorityQueueElement[])Arrays.copyOf(this.queue, desiredSize);
        } else if (AbstractHeapPriorityQueue.isValidArraySize(minRequiredSize)) {
            this.queue = (HeapPriorityQueueElement[])Arrays.copyOf(this.queue, 0x7FFFFFF7);
        } else {
            throw new OutOfMemoryError("Required minimum heap size " + minRequiredSize + " exceeds maximum size of 2147483639.");
        }
    }

    protected void moveElementToIdx(T element, int idx) {
        this.queue[idx] = element;
        element.setInternalIndex(idx);
    }

    protected abstract T removeInternal(@Nonnegative int var1);

    protected abstract void addInternal(@Nonnull T var1);

    protected abstract int getHeadElementIndex();

    private static boolean isValidArraySize(int size) {
        return size >= 0 && size <= 0x7FFFFFF7;
    }

    private final class HeapIterator
    implements CloseableIterator<T> {
        private int runningIdx;
        private final int endIdx;

        HeapIterator() {
            this.runningIdx = AbstractHeapPriorityQueue.this.getHeadElementIndex();
            this.endIdx = this.runningIdx + AbstractHeapPriorityQueue.this.size;
        }

        @Override
        public boolean hasNext() {
            return this.runningIdx < this.endIdx;
        }

        @Override
        public T next() {
            if (this.runningIdx >= this.endIdx) {
                throw new NoSuchElementException("Iterator has no next element.");
            }
            return AbstractHeapPriorityQueue.this.queue[this.runningIdx++];
        }

        @Override
        public void close() {
        }
    }
}

