/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.metrics;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.jobgraph.JobType;
import org.apache.flink.runtime.scheduler.metrics.ExecutionStatusMetricsRegistrar;
import org.apache.flink.runtime.scheduler.metrics.StateTimeMetric;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.SystemClock;

public class DeploymentStateTimeMetrics
implements ExecutionStatusMetricsRegistrar,
StateTimeMetric {
    private static final long NOT_STARTED = -1L;
    private final Predicate<Integer> deploymentStartPredicate;
    private final Predicate<Integer> deploymentEndPredicate;
    private final MetricOptions.JobStatusMetricsSettings stateTimeMetricsSettings;
    private final Clock clock;
    private final Set<ExecutionAttemptID> expectedDeployments = new HashSet<ExecutionAttemptID>();
    private int pendingDeployments = 0;
    private int completedDeployments = 0;
    private long deploymentStart = -1L;
    private long deploymentTimeTotal = 0L;

    public DeploymentStateTimeMetrics(JobType semantic, MetricOptions.JobStatusMetricsSettings stateTimeMetricsSettings) {
        this(semantic, stateTimeMetricsSettings, SystemClock.getInstance());
    }

    @VisibleForTesting
    DeploymentStateTimeMetrics(JobType semantic, MetricOptions.JobStatusMetricsSettings stateTimeMetricsSettings, Clock clock) {
        this.stateTimeMetricsSettings = stateTimeMetricsSettings;
        this.clock = clock;
        if (semantic == JobType.BATCH) {
            this.deploymentStartPredicate = completedDeployments -> completedDeployments == 0;
            this.deploymentEndPredicate = completedDeployments -> completedDeployments > 0;
        } else {
            this.deploymentStartPredicate = completedDeployments -> true;
            this.deploymentEndPredicate = completedDeployments -> completedDeployments.intValue() == this.expectedDeployments.size();
        }
    }

    @Override
    public long getCurrentTime() {
        return this.deploymentStart == -1L ? 0L : Math.max(0L, this.clock.absoluteTimeMillis() - this.deploymentStart);
    }

    @Override
    public long getTotalTime() {
        return this.getCurrentTime() + this.deploymentTimeTotal;
    }

    @Override
    public long getBinary() {
        return this.deploymentStart == -1L ? 0L : 1L;
    }

    @Override
    public void registerMetrics(MetricGroup metricGroup) {
        StateTimeMetric.register(this.stateTimeMetricsSettings, metricGroup, this, "deploying");
    }

    @Override
    public void onStateUpdate(ExecutionAttemptID execution, ExecutionState previousState, ExecutionState newState) {
        switch (newState) {
            case SCHEDULED: {
                this.expectedDeployments.add(execution);
                break;
            }
            case DEPLOYING: {
                ++this.pendingDeployments;
                break;
            }
            case INITIALIZING: 
            case RUNNING: {
                ++this.completedDeployments;
                break;
            }
            default: {
                this.expectedDeployments.remove(execution);
            }
        }
        switch (previousState) {
            case DEPLOYING: {
                --this.pendingDeployments;
                break;
            }
            case INITIALIZING: 
            case RUNNING: {
                --this.completedDeployments;
            }
        }
        if (this.deploymentStart == -1L) {
            if (this.pendingDeployments > 0 && this.deploymentStartPredicate.test(this.completedDeployments)) {
                this.markDeploymentStart();
            }
        } else if (this.deploymentEndPredicate.test(this.completedDeployments) || this.expectedDeployments.isEmpty()) {
            this.markDeploymentEnd();
        }
    }

    private void markDeploymentStart() {
        this.deploymentStart = this.clock.absoluteTimeMillis();
    }

    private void markDeploymentEnd() {
        this.deploymentTimeTotal += Math.max(0L, this.clock.absoluteTimeMillis() - this.deploymentStart);
        this.deploymentStart = -1L;
    }

    @VisibleForTesting
    boolean hasCleanState() {
        return this.expectedDeployments.isEmpty() && this.pendingDeployments == 0 && this.completedDeployments == 0 && this.deploymentStart == -1L;
    }
}

