/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive.allocator;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.instance.SlotSharingGroupId;
import org.apache.flink.runtime.jobmaster.SlotInfo;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlot;
import org.apache.flink.runtime.scheduler.adaptive.allocator.JobInformation;
import org.apache.flink.runtime.scheduler.adaptive.allocator.SlotSharingSlotAllocator;
import org.apache.flink.util.Preconditions;

class AllocatorUtil {
    private AllocatorUtil() {
    }

    static Map<SlotSharingGroupId, SlotSharingSlotAllocator.SlotSharingGroupMetaInfo> getSlotSharingGroupMetaInfos(JobInformation jobInformation) {
        return SlotSharingSlotAllocator.SlotSharingGroupMetaInfo.from(jobInformation.getVertices());
    }

    static int getMinimumRequiredSlots(Map<SlotSharingGroupId, SlotSharingSlotAllocator.SlotSharingGroupMetaInfo> slotSharingGroupMetaInfos) {
        return slotSharingGroupMetaInfos.values().stream().map(SlotSharingSlotAllocator.SlotSharingGroupMetaInfo::getMaxLowerBound).reduce(0, Integer::sum);
    }

    static void checkMinimumRequiredSlots(JobInformation jobInformation, Collection<? extends SlotInfo> freeSlots) {
        int minimumRequiredSlots = AllocatorUtil.getMinimumRequiredSlots(AllocatorUtil.getSlotSharingGroupMetaInfos(jobInformation));
        Preconditions.checkState(freeSlots.size() >= minimumRequiredSlots, "Not enough slots to allocate all the execution slot sharing groups (have: %s, need: %s)", freeSlots.size(), minimumRequiredSlots);
    }

    static Map<ResourceID, Set<PhysicalSlot>> getSlotsPerTaskExecutor(Collection<PhysicalSlot> physicalSlots) {
        return physicalSlots.stream().collect(Collectors.groupingBy(slot -> slot.getTaskManagerLocation().getResourceID(), Collectors.toSet()));
    }
}

