/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.time.Duration;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.jobmaster.slotpool.AbstractSlotPoolServiceFactory;
import org.apache.flink.runtime.jobmaster.slotpool.DeclarativeSlotPoolBridge;
import org.apache.flink.runtime.jobmaster.slotpool.DeclarativeSlotPoolFactory;
import org.apache.flink.runtime.jobmaster.slotpool.RequestSlotMatchingStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPoolService;
import org.apache.flink.util.clock.Clock;

public class DeclarativeSlotPoolBridgeServiceFactory
extends AbstractSlotPoolServiceFactory {
    private final RequestSlotMatchingStrategy requestSlotMatchingStrategy;

    public DeclarativeSlotPoolBridgeServiceFactory(@Nonnull Clock clock, @Nonnull Duration rpcTimeout, @Nonnull Duration slotIdleTimeout, @Nonnull Duration batchSlotTimeout, @Nonnull Duration slotRequestMaxInterval, boolean deferSlotAllocation, @Nonnull RequestSlotMatchingStrategy requestSlotMatchingStrategy) {
        super(clock, rpcTimeout, slotIdleTimeout, batchSlotTimeout, slotRequestMaxInterval, deferSlotAllocation);
        this.requestSlotMatchingStrategy = requestSlotMatchingStrategy;
    }

    @Override
    @Nonnull
    public SlotPoolService createSlotPoolService(@Nonnull JobID jobId, DeclarativeSlotPoolFactory declarativeSlotPoolFactory, @Nonnull ComponentMainThreadExecutor componentMainThreadExecutor) {
        return new DeclarativeSlotPoolBridge(jobId, declarativeSlotPoolFactory, this.clock, this.rpcTimeout, this.slotIdleTimeout, this.batchSlotTimeout, this.requestSlotMatchingStrategy, this.slotRequestMaxInterval, this.deferSlotAllocation, componentMainThreadExecutor);
    }
}

