/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.execution;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.core.execution.JobStatusChangedListener;
import org.apache.flink.core.execution.JobStatusChangedListenerFactory;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.InstantiationUtil;

@Internal
public final class JobStatusChangedListenerUtils {
    public static List<JobStatusChangedListener> createJobStatusChangedListeners(final ClassLoader userClassLoader, final Configuration configuration, final Executor ioExecutor) {
        List<String> jobStatusChangedListeners = configuration.get(DeploymentOptions.JOB_STATUS_CHANGED_LISTENERS);
        if (jobStatusChangedListeners == null || jobStatusChangedListeners.isEmpty()) {
            return Collections.emptyList();
        }
        return jobStatusChangedListeners.stream().map(fac -> {
            try {
                return InstantiationUtil.instantiate(fac, JobStatusChangedListenerFactory.class, userClassLoader).createListener(new JobStatusChangedListenerFactory.Context(){

                    @Override
                    public Configuration getConfiguration() {
                        return configuration;
                    }

                    @Override
                    public ClassLoader getUserClassLoader() {
                        return userClassLoader;
                    }

                    @Override
                    public Executor getIOExecutor() {
                        return ioExecutor;
                    }
                });
            }
            catch (FlinkException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }
}

